import { Redis } from '@upstash/redis';
import dotenv from 'dotenv';

dotenv.config();

const redis = new Redis({
  url: process.env.URL_SOCKET,
  token: process.env.TOKEN_SOCKET,
});

export const getuser = async (Phone: string): Promise<string | null> => {
  return await redis.get(`usersoket:${Phone}`);
};


export const getastro = async (Phone: string): Promise<string | null>  => {
    
    return await redis.get(`setastro:${Phone}`);
  };



export default redis;
