// import cron from 'node-cron';
// import { sequelize } from '../config/db';
// import { QueryTypes } from 'sequelize';


// cron.schedule('* * * * *', async () => {
//   try {
//     const now = new Date();

//     const activeSlots: any[] = await sequelize.query(
//       `SELECT * FROM astrologer_free_slots 
//        WHERE start_time <= :now AND end_time >= :now`,
//       { replacements: { now }, type: QueryTypes.SELECT }
//     );

//     for (const slot of activeSlots) {
//       const [astro]: any = await sequelize.query(
//         `SELECT * FROM astrologer WHERE id = :id`,
//         { replacements: { id: slot.astrologer_id }, type: QueryTypes.SELECT }
//       );

//       if (astro && astro.is_free === 0) {
//         await sequelize.query(
//           `UPDATE astrologer 
//            SET original_price = price, price = 0, is_free = 1
//            WHERE id = :id`,
//           { replacements: { id: slot.astrologer_id }, type: QueryTypes.UPDATE }
//         );

//         // console.log(`Astrologer ${slot.astrologer_id} → FREE`);
//       }
//     }

//     const endedSlots: any[] = await sequelize.query(
//       `SELECT * FROM astrologer_free_slots 
//        WHERE end_time < :now`,
//       { replacements: { now }, type: QueryTypes.SELECT }
//     );

//     for (const slot of endedSlots) {
//       const [astro]: any = await sequelize.query(
//         `SELECT * FROM astrologer WHERE id = :id`,
//         { replacements: { id: slot.astrologer_id }, type: QueryTypes.SELECT }
//       );

//       if (astro && astro.is_free === 1) {
//         await sequelize.query(
//           `UPDATE astrologer 
//            SET price = original_price, is_free = 0
//            WHERE id = :id`,
//           { replacements: { id: slot.astrologer_id }, type: QueryTypes.UPDATE }
//         );

//         // console.log(`Astrologer ${slot.astrologer_id} → PRICE RESTORED`);
//       }

//       if (slot.repeat_daily) {
//         await sequelize.query(
//           `UPDATE astrologer_free_slots
//            SET 
//              start_time = DATE_ADD(start_time, INTERVAL 1 DAY),
//              end_time   = DATE_ADD(end_time,   INTERVAL 1 DAY)
//            WHERE id = :id`,
//           { replacements: { id: slot.id }, type: QueryTypes.UPDATE }
//         );

//         // console.log(`Slot ${slot.id} → Shifted to next day`);
//       } else {
//         // console.log(`Slot ${slot.id} ended (repeat_daily = 0)`);
//       }
//     }

//   } catch (error) {
//     // console.error("Free Slot CRON Error:", error);
//   }
// });



import cron from "node-cron";
import { sequelize } from "../config/db";
import { QueryTypes } from "sequelize";

cron.schedule("* * * * *", async () => {
  try {
    const now = new Date();

    // 1️⃣ Active slots → Make astrologer FREE
    await sequelize.query(
      `
      UPDATE astrologer a
      JOIN astrologer_free_slots s 
        ON a.id = s.astrologer_id
      SET 
        a.original_price = a.price,
        a.price = 0,
        a.is_free = 1
      WHERE 
        s.start_time <= :now
        AND s.end_time >= :now
        AND a.is_free = 0
      `,
      { replacements: { now }, type: QueryTypes.UPDATE }
    );

    // 2️⃣ Ended slots → Restore price
    await sequelize.query(
      `
      UPDATE astrologer a
      JOIN astrologer_free_slots s 
        ON a.id = s.astrologer_id
      SET 
        a.price = a.original_price,
        a.is_free = 0
      WHERE 
        s.end_time < :now
        AND a.is_free = 1
      `,
      { replacements: { now }, type: QueryTypes.UPDATE }
    );

    // 3️⃣ Repeat daily → Shift slot
    await sequelize.query(
      `
      UPDATE astrologer_free_slots
      SET 
        start_time = DATE_ADD(start_time, INTERVAL 1 DAY),
        end_time   = DATE_ADD(end_time,   INTERVAL 1 DAY)
      WHERE 
        end_time < :now
        AND repeat_daily = 1
      `,
      { replacements: { now }, type: QueryTypes.UPDATE }
    );

  } catch (err) {
    console.error("FREE SLOT CRON ERROR:", err);
  }
});
