import cron from 'node-cron';
import axios from 'axios';
import mongoose from 'mongoose';
import dotenv from 'dotenv';

dotenv.config();

// Use environment variable for MongoDB connection
const MONGODB_URI = process.env.MONGODB_URI || "mongodb+srv://ankitdonhai:MGQEJ1DUF7V1VSds@cluster0.ad27ekx.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0";

mongoose.connect(MONGODB_URI)
  .then(() => console.log("Connected to MongoDB"))
  .catch(err => console.error("DB Error:", err.message));


const PanchangSchema = new mongoose.Schema({
  date: { type: Date, default: Date.now },
  day: String,
  tithi: String,
  nakshatra: String,
  yog: String,
  karan: String,
  sunrise: String,
  sunset: String,
  vedic_sunrise: String,
  vedic_sunset: String,
});

const Panchang = mongoose.model('Panchang', PanchangSchema);


cron.schedule('15 7 * * *', async () => {
  console.log('Fetching Panchang at 7:15 AM');

  const now = new Date();

  const requestBody = {
    day: now.getDate(),
    month: now.getMonth() + 1,
    year: now.getFullYear(),
    hour: 7,
    min: 15,
    lat: 28.6139,
    lon: 77.2090,
    tzone: 5.5
  };

  try {
    const response = await axios.post('https://backend.navambhaw.com/v2/alltimepanchang', requestBody);
    const data = response.data.message;

    const saved = await Panchang.create(data);
    console.log("Panchang saved:", saved._id);
  } catch (err) {
    if (err instanceof Error) {
      console.error("API call failed:", err.message);
    } else {
      console.error("API call failed:", err);
    }
  }
});
