// routes/yogaTrainerRoutes.ts

import { Router } from 'express';
import {
  sendOtpYoga,
  registerYogaTrainer,
  loginYogaTrainer,
  getAllYogaTrainersCtrl,
  getDetails
} from '../controllers/yogaTrainerController';
import {upload} from '../middelware/multer'; // multer middleware

const router = Router();

router.post('/send-otp', sendOtpYoga);
router.post('/register', upload.single('profileImage'), registerYogaTrainer);
router.post('/login', loginYogaTrainer);
router.get('/all', getAllYogaTrainersCtrl);

router.get('/teacher/:id', getDetails);

export default router;