import { Router } from 'express';
import { fetchAllAstrologer, fetchuserdeatils, fetchuserwallet, 
  fetchastrologerdeatils, updateastroprofileimage, fetchastrowallet, 
  fetchallpoojas, fetchpoojadata, getmarquee,getastrobank, updateAstrologerBank,
  userchathistory, getAstrologerInteractionHistory  } from '../controllers/servicesController';
import {upload }from '../middelware/multer';
const router = Router();

router.get("/fetchastrologers", fetchAllAstrologer);
router.post("/fetchclientdetail", fetchuserdeatils);
router.get("/fetchwalletuser", fetchuserwallet);
router.post("/fetchastrologerdetail",fetchastrologerdeatils);
router.put("/updateastroprofileimage",upload.single('Profile_image'), updateastroprofileimage);
router.post("/astrowalletdetail", fetchastrowallet);
router.get("/allpoojas", fetchallpoojas);
router.get("/poojadata", fetchpoojadata);
router.get("/marquee", getmarquee);
router.get("/astrobank", getastrobank);
router.post("/astrobankupdate", updateAstrologerBank);
router.get("/userchats", userchathistory);

router.get(
  "/admin/astrologer-interactions",
  getAstrologerInteractionHistory
);

import { getAdminAstrologerWallets } from '../controllers/servicesController';

router.get(
  "/admin/astrologer-wallets",
  getAdminAstrologerWallets
);



export default router;
