import { Router } from "express";
import { payoutAstrologer,getAstrologerPayoutHistory ,
    totalAdminEarning,
  todayAdminEarning,
  dateWiseAdminEarning,
  adminEarningByDate,
  todayAstrologerWiseAdminEarning,
  dateAstrologerWiseAdminEarning
} from "../controllers/payoutControllers";

const router = Router();

router.post(
  "/admin/astrologer-payout",
  payoutAstrologer
);

router.get(
  "/admin/astrologer-payout-history/:astrologer_id",
  getAstrologerPayoutHistory
);



router.get("/total", totalAdminEarning);
router.get("/today", todayAdminEarning);
router.get("/date-wise", dateWiseAdminEarning);
router.get("/date/:date", adminEarningByDate);
router.get(
  "/today/astrologer-wise",
  todayAstrologerWiseAdminEarning
);
router.get(
  "/date/:date/astrologer-wise",
  dateAstrologerWiseAdminEarning
);


export default router;
