import express from "express";
import {
  registerPandit,
  fetchAllPandits,
  fetchPanditById,
  fetchPanditByPhone,
  verifyPandit,
  unverifyPandit,
} from "../controllers/panditController";
import { upload } from "../middelware/multer";

const router = express.Router();


router.post(
  "/createpandit",
  upload.single('profileImage'),
  registerPandit
);


router.get("/pandit/phone/:phone", fetchPanditByPhone);
router.get("/allpandits", fetchAllPandits);
router.get("/pandit/:id", fetchPanditById);
router.get("/pandits", fetchAllPandits);
router.put("/pandits/verify/:id", verifyPandit);
router.put("/pandits/unverify/:id", unverifyPandit);


router.get("/test", (req, res) => {
  res.json({ message: "Pandit routes connected ✅" });
});

export default router;