import { Router } from "express";
import {
  fetchAllMarquees,
  addMarquee,
  updateMarquee,
  deleteMarquee,
} from "../controllers/MarqueeController";

const router = Router();

router.get("/", fetchAllMarquees);
router.post("/", addMarquee);
router.put("/:id", updateMarquee);
router.delete("/:id", deleteMarquee);

export default router;
