  import { Router } from 'express'; 
  import { Register, Login, Sendotp, FrogotpassendOTP, Forgotpass, updateastropass, 
      verifyAstrologerController, unverifyAstrologerController,fetchAstrologerPriceCommission, setAstrologerPriceCommission,getAllAstrologers,
  toggleFreeStatusByMobile, getAllAstrologersWithPriceCommission
  } from '../controllers/astrologerController';
  import {upload }from '../middelware/multer';
  const router = Router();

  router.post('/sendOTP', Sendotp);
  router.post('/createastrologer', upload.single('Profile_image'), Register);
  router.post('/forgotpassendOTP', FrogotpassendOTP);
  router.post('/forgotpass', Forgotpass);
  router.post('/login', Login); 
  router.post('/updatepass', updateastropass);// For the astrologer to handle there login


  // ✅ Verify astrologer
  router.put("/verify/:id", verifyAstrologerController);

  // ✅ Unverify astrologer
  router.put("/unverify/:id", unverifyAstrologerController);



  router.get("/test", (req, res) => {
    res.json({ message: "Astrologer routes connected ✅" });
  });


  // Update price & commission
  router.post("/update-price-commission", setAstrologerPriceCommission);

  router.get("/all-with-price-commission", getAllAstrologersWithPriceCommission);

  // Fetch existing price & commission
  router.get("/:astro_id/price-commission", fetchAstrologerPriceCommission);

  // 🔹 GET all astrologers
  router.get("/all", getAllAstrologers);

  router.post('/toggle-free-mobile', toggleFreeStatusByMobile);


  export default router;
