import express from 'express';
import {
  addFreeSlot,
  getFreeSlots,
  updateFreeSlot,
  deleteFreeSlot
} from '../controllers/astrologerFreeSlotController';

const router = express.Router();

router.post('/add', addFreeSlot);
router.get('/list', getFreeSlots);
router.put('/update', updateFreeSlot);
router.delete('/delete', deleteFreeSlot);

export default router;
