import { Redis } from '@upstash/redis';
import dotenv from 'dotenv';

dotenv.config();

const redis = new Redis({
  url: process.env.URL,
  token: process.env.TOKEN,
});
console.log(process.env.URL, process.env.TOKEN);
export const setOtp = async (Phone: string, otp: string): Promise<void> => {
  await redis.set(`otp:${Phone}`, otp, { ex: 300 }); 
};


export const getOtp = async (Phone: string): Promise<string | null> => {
  return await redis.get(`otp:${Phone}`);
};


export const deleteOtp = async (Phone: string): Promise<void> => {
  await redis.del(`otp:${Phone}`);
};

export default redis;
