import { sequelize } from '../config/db';
import { QueryTypes } from 'sequelize';



export interface User {
  id: number;
  name: string;
  contact: string;
  password: string;  
  coupon_code:string;
  email:string
  isverified:boolean;
}



export const createbpartnerAccount = async (name: string, Phone: string, passwordHash: string, coupon_code:string, email:string) => {
  try {
    await sequelize.query('CALL create_bpartner(:name, :PhoneNumber, :password, :email, :coupon_code )', {
      replacements: { name, PhoneNumber: Phone, password: passwordHash, coupon_code, email },
      type: QueryTypes.RAW,
    });

  } catch (error) {
    console.error('Error creating user:', error);
    throw error;
  }
};


 export const findbpartnerByContact = async (contact: string): Promise<User | null> => {
  try {
    const result = await sequelize.query('CALL login_bpartner(:contact)', {
      replacements: { contact },
      type: QueryTypes.SELECT,
    });

    const firstResult = result[0] as Record<string, User> | undefined;

    if (!firstResult) return null;

    const user = firstResult[Object.keys(firstResult)[0]];

    return user ?? null;
  } catch (error) {
    console.error('Error fetching user by contact:', error);
    throw error;
  }
};







export const updatebpartnerPassword = async (contact: string, hashedPassword: string): Promise<void> => {
  try {
    await sequelize.query(
      'CALL update_bpartner_password(:contact, :password)',
      {
        replacements: { contact, password: hashedPassword },
        type: QueryTypes.RAW,
      }
    );
  } catch (error) {
    console.error('Error updating user password:', error);
    throw error;
  }
};