import { sequelize } from '../config/db';
import { QueryTypes } from 'sequelize';

export interface AstrologerFreeSlot {
  id: number;
  astrologer_id: number;
  start_time: string;
  end_time: string;
  repeat_daily: number;
  created_at: string;
}


export const addAstrologerFreeSlot = async (
  astrologer_id: number,
  start_time: string,   
  end_time: string,    
  repeat_daily: number
) => {
  return await sequelize.query(
    `
    INSERT INTO astrologer_free_slots
    (astrologer_id, start_time, end_time, repeat_daily)
    VALUES (
      :astrologer_id,
      STR_TO_DATE(:start_time, '%Y-%m-%d %H:%i'),
      STR_TO_DATE(:end_time, '%Y-%m-%d %H:%i'),
      :repeat_daily
    )
    `,
    {
      replacements: {
        astrologer_id,
        start_time,
        end_time,
        repeat_daily
      },
      type: QueryTypes.INSERT
    }
  );
};


export const getAstrologerFreeSlots = async (
  astrologer_id: number
): Promise<AstrologerFreeSlot[]> => {
  const result = await sequelize.query(
    `
    SELECT *
    FROM astrologer_free_slots
    WHERE astrologer_id = :astrologer_id
    ORDER BY start_time ASC
    `,
    {
      replacements: { astrologer_id },
      type: QueryTypes.SELECT
    }
  );

  return result as AstrologerFreeSlot[];
};

export const updateAstrologerFreeSlot = async (
  id: number,
  start_time: string,
  end_time: string,
  repeat_daily: number
) => {
  return await sequelize.query(
    `
    UPDATE astrologer_free_slots
    SET
      start_time = STR_TO_DATE(:start_time, '%Y-%m-%d %H:%i'),
      end_time = STR_TO_DATE(:end_time, '%Y-%m-%d %H:%i'),
      repeat_daily = :repeat_daily
    WHERE id = :id
    `,
    {
      replacements: {
        id,
        start_time,
        end_time,
        repeat_daily
      },
      type: QueryTypes.UPDATE
    }
  );
};

export const deleteAstrologerFreeSlot = async (id: number) => {
  return await sequelize.query(
    `
    DELETE FROM astrologer_free_slots
    WHERE id = :id
    `,
    {
      replacements: { id },
      type: QueryTypes.DELETE
    }
  );
};
