import { sequelize } from '../config/db';
import { QueryTypes } from 'sequelize';

export interface Admin {
  admin_id: string;
  name: string;
  password:string;
}

export interface bpartner {
  id: string;
  name: string;
  phonenumber: string,
  email:string | null,
  isverified:boolean,
  created_at:string,
  coupon_code:string,
}

export const findAdminById = async (Adminid: string): Promise<Admin | null> => {
    try {
      const result = await sequelize.query('CALL GetadminWithId(:Adminid)', {
        replacements: { Adminid },
        type: QueryTypes.SELECT,
      });
  
      const firstResult = result[0] as Record<string, Admin> | undefined;
  
      if (!firstResult) return null;
  
      const admin = firstResult[Object.keys(firstResult)[0]];
  
      return admin ?? null;
    } catch (error) {
      console.error('Error fetching user by contact:', error);
      throw error;
    }
  };


  export const findAllbpartner = async (): Promise<bpartner[] | null> => {
    
    try {
      const result = await sequelize.query('CALL GetAllBpartner()', {
        type: QueryTypes.RAW,
      });
  
      const bpartner: bpartner[] = Array.isArray(result) ? (result as bpartner[]) : [];
  
      return bpartner ?? null;
    } catch (error) {
      console.error('Error fetching user by contact:', error);
      throw error;
    }
  };
  