import { DataTypes, Model } from "sequelize";
import { sequelize } from "../config/db";

export class Marquee extends Model {
  public id!: number;
  public marquee_text!: string;
  public banner!: string | null;
  public readonly created_at!: Date;
}

Marquee.init(
  {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      autoIncrement: true,
      primaryKey: true,
    },
    marquee_text: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    banner: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    tableName: "marquee_banners",
    timestamps: false, // kyunki table me sirf created_at hai
  }
);
