import multer from 'multer';
import path from 'path';
import fs from 'fs';

const UPLOAD_DIR_ASTROPROFILE = '/home/backendnavambhaw/public_html/uploads';
const UPLOAD_DIR_USERPROFILE = '/home/backendnavambhaw/public_html/user_profile';
const UPLOAD_DIR_POOJAIMAGE = '/home/backendnavambhaw/public_html/pooja_image';


try {
    if (!fs.existsSync(UPLOAD_DIR_ASTROPROFILE)) {
        fs.mkdirSync(UPLOAD_DIR_ASTROPROFILE, { recursive: true });
    }
} catch (error) {
    console.error('Error creating upload directory:', error);
}

const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, UPLOAD_DIR_ASTROPROFILE);
    },
    filename: (req, file, cb) => {
        const uniqueName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${path.extname(file.originalname)}`;
        cb(null, uniqueName);
    }
});



const fileFilter = (req: any, file: Express.Multer.File, cb: multer.FileFilterCallback) => {
    if (file.mimetype.startsWith('image/')) {
        cb(null, true);
    } else {
        cb(new Error('Only image files are allowed!'));
    }
};

export const upload = multer({ 
    storage,
    fileFilter,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    }
});

