const axios = require('axios');
const mongoose = require('mongoose');

// MongoDB Schema
const PanchangSchema = new mongoose.Schema({
  date: { type: Date, default: Date.now },
  day: String,
  tithi: String,
  nakshatra: String,
  yog: String,
  karan: String,
  sunrise: String,
  sunset: String,
  vedic_sunrise: String,
  vedic_sunset: String,
});

const Panchang = mongoose.model('Panchang', PanchangSchema);

exports.handler = async (event, context) => {
  try {
    console.log('Lambda function started at:', new Date().toISOString());
    
    // Connect to MongoDB
    const MONGODB_URI = process.env.MONGODB_URI || "mongodb+srv://ankitdonhai:MGQEJ1DUF7V1VSds@cluster0.ad27ekx.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0";
    
    await mongoose.connect(MONGODB_URI, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });
    console.log('Connected to MongoDB');

    const now = new Date();
    console.log('Fetching Panchang at:', now.toISOString());

    const requestBody = {
      day: now.getDate(),
      month: now.getMonth() + 1,
      year: now.getFullYear(),
      hour: 7,
      min: 15,
      lat: 28.6139,
      lon: 77.2090,
      tzone: 5.5
    };

    // Fetch panchang data
    const response = await axios.post('https://backend.navambhaw.com/v2/alltimepanchang', requestBody);
    const data = response.data.message;

    // Save to database
    const saved = await Panchang.create(data);
    console.log("Panchang saved:", saved._id);

    // Close MongoDB connection
    await mongoose.connection.close();

    return {
      statusCode: 200,
      body: JSON.stringify({
        success: true,
        message: 'Panchang fetched and saved successfully',
        panchangId: saved._id,
        timestamp: now.toISOString()
      })
    };

  } catch (error) {
    console.error('Lambda function error:', error);
    
    // Close MongoDB connection if it's open
    if (mongoose.connection.readyState === 1) {
      await mongoose.connection.close();
    }

    return {
      statusCode: 500,
      body: JSON.stringify({
        success: false,
        error: error.message,
        timestamp: new Date().toISOString()
      })
    };
  }
};
