# AWS Lambda Cron Job for Panchang

This directory contains the AWS Lambda function and deployment scripts for running your panchang cron job.

## 🚀 **Option 1: AWS Lambda + EventBridge (Recommended)**

### **Advantages:**
- ✅ **Highly Reliable**: AWS managed service with 99.9% uptime
- ✅ **Cost Effective**: Pay only for execution time (~$0.20 per million requests)
- ✅ **Scalable**: Handles any load automatically
- ✅ **Monitoring**: Built-in CloudWatch logs and metrics
- ✅ **No Server Management**: Fully managed by AWS

### **Prerequisites:**
1. AWS Account
2. AWS CLI installed and configured
3. Node.js 18+ installed

### **Quick Deployment:**

```bash
# 1. Navigate to lambda directory
cd lambda

# 2. Set your MongoDB URI
export MONGODB_URI="your_mongodb_connection_string"

# 3. Make deploy script executable
chmod +x deploy.sh

# 4. Run deployment
./deploy.sh
```

### **Manual Deployment Steps:**

```bash
# 1. Install dependencies
npm install

# 2. Create deployment package
zip -r function.zip . -x "*.git*" "node_modules/.cache/*" "deploy.sh" "template.yaml"

# 3. Deploy using CloudFormation
aws cloudformation deploy \
    --template-file template.yaml \
    --stack-name panchang-cron-stack \
    --parameter-overrides MongoDBUri="$MONGODB_URI" \
    --capabilities CAPABILITY_IAM \
    --region us-east-1
```

## 🕐 **Option 2: Vercel Cron Jobs (Alternative)**

If you prefer to keep everything on Vercel:

### **Advantages:**
- ✅ **Simple**: No AWS setup required
- ✅ **Integrated**: Works with your existing Vercel deployment
- ❌ **Limited**: Only available on Pro plan ($20/month)
- ❌ **Less Reliable**: Depends on Vercel's infrastructure

### **Setup:**
Your `vercel.json` already includes cron configuration:
```json
{
  "crons": [
    {
      "path": "/api/cron",
      "schedule": "15 7 * * *"
    }
  ]
}
```

## 📊 **Monitoring & Logs**

### **AWS Lambda:**
- **CloudWatch Logs**: Automatic logging of all executions
- **CloudWatch Metrics**: Execution time, errors, invocations
- **AWS Console**: Real-time monitoring dashboard

### **Vercel:**
- **Function Logs**: Available in Vercel dashboard
- **Analytics**: Basic metrics in Pro plan

## 💰 **Cost Comparison**

| Service | Cost | Reliability | Setup Complexity |
|---------|------|-------------|------------------|
| **AWS Lambda** | ~$0.20/month | 99.9% | Medium |
| **Vercel Cron** | $20/month (Pro) | 99% | Low |
| **External Service** | $5-50/month | Varies | Low |

## 🔧 **Configuration Options**

### **Schedule Formats:**

**AWS EventBridge:**
```bash
# Daily at 7:15 AM UTC
cron(15 7 * * ? *)

# Every hour
rate(1 hour)

# Every 5 minutes
rate(5 minutes)
```

**Vercel Cron:**
```bash
# Daily at 7:15 AM UTC
15 7 * * *

# Every hour
0 * * * *
```

## 🛠️ **Customization**

### **Change Schedule:**
Edit the `CronSchedule` parameter in `template.yaml` or update `vercel.json`.

### **Add Error Handling:**
The Lambda function includes comprehensive error handling and logging.

### **Environment Variables:**
- `MONGODB_URI`: Your MongoDB connection string
- Add more as needed in the CloudFormation template

## 🔍 **Testing**

### **Test Lambda Function:**
```bash
# Test manually via AWS Console or CLI
aws lambda invoke \
    --function-name panchang-cron \
    --payload '{}' \
    response.json
```

### **Test Vercel Cron:**
```bash
# Test manual trigger
curl -X POST https://your-app.vercel.app/api/trigger-cron
```

## 📝 **Troubleshooting**

### **Common Issues:**

1. **MongoDB Connection Failed**
   - Check connection string
   - Verify network access
   - Check credentials

2. **Lambda Timeout**
   - Increase timeout in CloudFormation template
   - Optimize database queries

3. **Permission Errors**
   - Ensure IAM role has proper permissions
   - Check CloudFormation deployment

## 🎯 **Recommendation**

**Use AWS Lambda** if you want:
- Maximum reliability
- Cost efficiency
- Professional monitoring
- Scalability

**Use Vercel Cron** if you want:
- Simplicity
- Everything in one place
- Already have Vercel Pro

## 📞 **Support**

- **AWS Lambda**: AWS documentation and support
- **Vercel**: Vercel documentation and community
- **MongoDB**: MongoDB Atlas support
