"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getastro = exports.getuser = void 0;
const redis_1 = require("@upstash/redis");
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
const redis = new redis_1.Redis({
    url: process.env.URL_SOCKET,
    token: process.env.TOKEN_SOCKET,
});
const getuser = async (Phone) => {
    return await redis.get(`usersoket:${Phone}`);
};
exports.getuser = getuser;
const getastro = async (Phone) => {
    return await redis.get(`setastro:${Phone}`);
};
exports.getastro = getastro;
exports.default = redis;
