"use strict";
// routes/yogaTrainerRoutes.ts
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const yogaTrainerController_1 = require("../controllers/yogaTrainerController");
const multer_1 = require("../middelware/multer"); // multer middleware
const router = (0, express_1.Router)();
router.post('/send-otp', yogaTrainerController_1.sendOtpYoga);
router.post('/register', multer_1.upload.single('profileImage'), yogaTrainerController_1.registerYogaTrainer);
router.post('/login', yogaTrainerController_1.loginYogaTrainer);
router.get('/all', yogaTrainerController_1.getAllYogaTrainersCtrl);
router.get('/teacher/:id', yogaTrainerController_1.getDetails);
exports.default = router;
