"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const servicesController_1 = require("../controllers/servicesController");
const multer_1 = require("../middelware/multer");
const router = (0, express_1.Router)();
router.get("/fetchastrologers", servicesController_1.fetchAllAstrologer);
router.post("/fetchclientdetail", servicesController_1.fetchuserdeatils);
router.get("/fetchwalletuser", servicesController_1.fetchuserwallet);
router.post("/fetchastrologerdetail", servicesController_1.fetchastrologerdeatils);
router.put("/updateastroprofileimage", multer_1.upload.single('Profile_image'), servicesController_1.updateastroprofileimage);
router.post("/astrowalletdetail", servicesController_1.fetchastrowallet);
router.get("/allpoojas", servicesController_1.fetchallpoojas);
router.get("/poojadata", servicesController_1.fetchpoojadata);
router.get("/marquee", servicesController_1.getmarquee);
router.get("/astrobank", servicesController_1.getastrobank);
router.post("/astrobankupdate", servicesController_1.updateAstrologerBank);
router.get("/userchats", servicesController_1.userchathistory);
router.get("/admin/astrologer-interactions", servicesController_1.getAstrologerInteractionHistory);
const servicesController_2 = require("../controllers/servicesController");
router.get("/admin/astrologer-wallets", servicesController_2.getAdminAstrologerWallets);
exports.default = router;
