"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const payoutControllers_1 = require("../controllers/payoutControllers");
const router = (0, express_1.Router)();
router.post("/admin/astrologer-payout", payoutControllers_1.payoutAstrologer);
router.get("/admin/astrologer-payout-history/:astrologer_id", payoutControllers_1.getAstrologerPayoutHistory);
router.get("/total", payoutControllers_1.totalAdminEarning);
router.get("/today", payoutControllers_1.todayAdminEarning);
router.get("/date-wise", payoutControllers_1.dateWiseAdminEarning);
router.get("/date/:date", payoutControllers_1.adminEarningByDate);
router.get("/today/astrologer-wise", payoutControllers_1.todayAstrologerWiseAdminEarning);
router.get("/date/:date/astrologer-wise", payoutControllers_1.dateAstrologerWiseAdminEarning);
exports.default = router;
