"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const panditController_1 = require("../controllers/panditController");
const multer_1 = require("../middelware/multer");
const router = express_1.default.Router();
router.post("/createpandit", multer_1.upload.single('profileImage'), panditController_1.registerPandit);
router.get("/pandit/phone/:phone", panditController_1.fetchPanditByPhone);
router.get("/allpandits", panditController_1.fetchAllPandits);
router.get("/pandit/:id", panditController_1.fetchPanditById);
router.get("/pandits", panditController_1.fetchAllPandits);
router.put("/pandits/verify/:id", panditController_1.verifyPandit);
router.put("/pandits/unverify/:id", panditController_1.unverifyPandit);
router.get("/test", (req, res) => {
    res.json({ message: "Pandit routes connected ✅" });
});
exports.default = router;
