"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const kundaliControllers_1 = require("../controllers/kundaliControllers");
const router = (0, express_1.Router)();
router.post('/astro_deatils', kundaliControllers_1.astrodeatils);
router.post('/birth_details', kundaliControllers_1.birthdetails);
router.post('/planets', kundaliControllers_1.planets);
router.post('/ghat_chakra', kundaliControllers_1.ghatchakra); //not in plan
router.post('/current_vdasha', kundaliControllers_1.currentvdasha);
router.post('/kalsarpa_details', kundaliControllers_1.kalsarpadetails);
router.post('/numero_table', kundaliControllers_1.numerotable);
router.post('/horo_chart/d1', kundaliControllers_1.horochartd1);
router.post('/horo_chart/d9', kundaliControllers_1.horochartd1);
router.post('/horo_chart_image/d1', kundaliControllers_1.horochartimaged1);
router.post('/horo_chart_image/d9', kundaliControllers_1.horochartimaged9);
router.get('/basic_panchang', kundaliControllers_1.basicpanchang);
router.post('/alltimepanchang', kundaliControllers_1.alltimepancahng);
router.post('/genral_ascendant_report', kundaliControllers_1.genralascendantreport);
router.post('/geo_details', kundaliControllers_1.geodetails);
router.post('/timezone', kundaliControllers_1.timezone);
router.post('/timzone_with_dst', kundaliControllers_1.timzonewithdst);
exports.default = router;
