"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const astrologerController_1 = require("../controllers/astrologerController");
const multer_1 = require("../middelware/multer");
const router = (0, express_1.Router)();
router.post('/sendOTP', astrologerController_1.Sendotp);
router.post('/createastrologer', multer_1.upload.single('Profile_image'), astrologerController_1.Register);
router.post('/forgotpassendOTP', astrologerController_1.FrogotpassendOTP);
router.post('/forgotpass', astrologerController_1.Forgotpass);
router.post('/login', astrologerController_1.Login);
router.post('/updatepass', astrologerController_1.updateastropass); // For the astrologer to handle there login
// ✅ Verify astrologer
router.put("/verify/:id", astrologerController_1.verifyAstrologerController);
// ✅ Unverify astrologer
router.put("/unverify/:id", astrologerController_1.unverifyAstrologerController);
router.get("/test", (req, res) => {
    res.json({ message: "Astrologer routes connected ✅" });
});
// Update price & commission
router.post("/update-price-commission", astrologerController_1.setAstrologerPriceCommission);
router.get("/all-with-price-commission", astrologerController_1.getAllAstrologersWithPriceCommission);
// Fetch existing price & commission
router.get("/:astro_id/price-commission", astrologerController_1.fetchAstrologerPriceCommission);
// 🔹 GET all astrologers
router.get("/all", astrologerController_1.getAllAstrologers);
router.post('/toggle-free-mobile', astrologerController_1.toggleFreeStatusByMobile);
exports.default = router;
