"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteOtp = exports.getOtp = exports.setOtp = void 0;
const redis_1 = require("@upstash/redis");
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
const redis = new redis_1.Redis({
    url: process.env.URL,
    token: process.env.TOKEN,
});
console.log(process.env.URL, process.env.TOKEN);
const setOtp = async (Phone, otp) => {
    await redis.set(`otp:${Phone}`, otp, { ex: 300 });
};
exports.setOtp = setOtp;
const getOtp = async (Phone) => {
    return await redis.get(`otp:${Phone}`);
};
exports.getOtp = getOtp;
const deleteOtp = async (Phone) => {
    await redis.del(`otp:${Phone}`);
};
exports.deleteOtp = deleteOtp;
exports.default = redis;
