"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllUsers = exports.updateUserPass = exports.updateUserPassword = exports.findUserByContact = exports.createUserAccount = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const bcryptjs_1 = __importDefault(require("bcryptjs"));
// export const createUserAccount = async (name: string, Phone: string, passwordHash: string) => {
//   try {
//     await sequelize.query('CALL CreateUser(:name, :PhoneNumber, :password)', {
//       replacements: { name, PhoneNumber: Phone, password: passwordHash },
//       type: QueryTypes.RAW,
//     });
//   } catch (error) {
//     console.error('Error creating user:', error);
//     throw error;
//   }
// };
const createUserAccount = async (name, Phone, passwordHash, email, address, state, pincode, dob, birthplace) => {
    try {
        await db_1.sequelize.query('CALL CreateUser(:name, :phoneNumber, :password, :email, :address, :state, :pincode, :dob, :birthplace)', {
            replacements: {
                name,
                phoneNumber: Phone, // ✔ must match :phoneNumber
                password: passwordHash,
                email,
                address,
                state,
                pincode,
                dob,
                birthplace
            },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        console.error('Error creating user:', error);
        throw error;
    }
};
exports.createUserAccount = createUserAccount;
const findUserByContact = async (contact) => {
    try {
        const result = await db_1.sequelize.query('CALL GetUserWithContact(:contact)', {
            replacements: { contact },
            type: sequelize_1.QueryTypes.SELECT,
        });
        const firstResult = result[0];
        if (!firstResult)
            return null;
        const user = firstResult[Object.keys(firstResult)[0]];
        return user ?? null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.findUserByContact = findUserByContact;
const updateUserPassword = async (contact, hashedPassword) => {
    try {
        await db_1.sequelize.query('CALL UpdateUserPassword(:contact, :password)', {
            replacements: { contact, password: hashedPassword },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        console.error('Error updating user password:', error);
        throw error;
    }
};
exports.updateUserPassword = updateUserPassword;
const updateUserPass = async (user_id, current_password, new_password) => {
    try {
        const [user] = await db_1.sequelize.query('SELECT password FROM users_table WHERE id = :user_id', {
            replacements: { user_id },
            type: sequelize_1.QueryTypes.SELECT,
        });
        if (!user || !user.password) {
            throw new Error('User not found');
        }
        const isMatch = await bcryptjs_1.default.compare(current_password, user.password);
        if (!isMatch) {
            throw new Error('Incorrect current password');
        }
        const hashedPassword = await bcryptjs_1.default.hash(new_password, 10);
        await db_1.sequelize.query('CALL UpdateUserPass(:user_id, :hashedPassword)', {
            replacements: { user_id, hashedPassword },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        throw error;
    }
};
exports.updateUserPass = updateUserPass;
const getAllUsers = async () => {
    try {
        const result = await db_1.sequelize.query("CALL GetAllUsers()", {
            type: sequelize_1.QueryTypes.SELECT
        });
        return result; // array of all users
    }
    catch (error) {
        console.error("Error fetching all users:", error);
        throw error;
    }
};
exports.getAllUsers = getAllUsers;
