"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchAdminAstrologerWallets = exports.fetchAstrologerInteractionHistory = exports.fetchusechathistory = exports.updateAstroBank = exports.fetchastrobank = exports.fetchmarquee = exports.fetchpoojadetails = exports.fetchAllPoojas = exports.UpdateAstroProfileImage = exports.fetchastrologerwalletdata = exports.fetchwalletbalance = exports.updateUserDetails = exports.fetchuserdata = exports.fetchastrologerdata = exports.fetchAllAstrologers = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const fetchAllAstrologers = async () => {
    try {
        const results = await db_1.sequelize.query('CALL GetVerifiedAstrologers()', {
            type: sequelize_1.QueryTypes.RAW,
        });
        const astrologers = Array.isArray(results) ? results : [];
        return astrologers || null;
    }
    catch (error) {
        console.error('Error fetching astrologers:', error);
        throw new Error('Failed to fetch astrologer data');
    }
};
exports.fetchAllAstrologers = fetchAllAstrologers;
const fetchastrologerdata = async (contact) => {
    try {
        const result = await db_1.sequelize.query('CALL GetAstrologerdataWithContact(:contact)', {
            replacements: { contact },
            type: sequelize_1.QueryTypes.RAW,
        });
        const astrologer = Array.isArray(result) ? result : [];
        return astrologer[0] || null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.fetchastrologerdata = fetchastrologerdata;
const fetchuserdata = async (contact) => {
    try {
        const result = await db_1.sequelize.query('CALL GetUserdataWithContact(:contact)', {
            replacements: { contact },
            type: sequelize_1.QueryTypes.RAW,
        });
        const users = Array.isArray(result) ? result : [];
        return users[0] || null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.fetchuserdata = fetchuserdata;
//   export const updateUserDetails = async (contact: string, name: string, email: string, gender: string): Promise<User | null> => {
//     try {
//         const result = await sequelize.query('CALL UpdateUser(:contact, :name, :email, :gender)', {
//             replacements: { contact, name, email, gender },
//             type: QueryTypes.RAW,
//         });
//         const updatedUser: User[] = Array.isArray(result) ? (result as User[]) : [];
//         return updatedUser[0] || null;
//     } catch (error) {
//         console.error('Error updating user details:', error);
//         throw new Error('Failed to update user data');
//     }
// };
// export const updateUserDetails = async (
//   contact: string,
//   name: string,
//   email: string,
//   gender: string
// ): Promise<boolean> => {
//   try {
//     const result = await sequelize.query(
//       `
//       UPDATE users_table
//       SET 
//         username = :name,
//         email = :email,
//         gender = :gender,
//         updated_at = NOW()
//       WHERE mobileNumber = :contact
//       `,
//       {
//         replacements: { name, email, gender, contact },
//         type: QueryTypes.UPDATE,
//       }
//     );
//     // MySQL returns affected rows count at index 1
//     const affectedRows = result[1] as number;
//     return affectedRows > 0;
//   } catch (error) {
//     console.error("Error updating user details:", error);
//     throw new Error("Failed to update user data");
//   }
// };
const updateUserDetails = async (contact, name, email, gender) => {
    try {
        const result = await db_1.sequelize.query("CALL UpdateUser(:contact, :name, :email, :gender)", {
            replacements: {
                contact,
                name,
                email,
                gender,
            },
        });
        return true;
    }
    catch (error) {
        console.error("Error updating user details:", error);
        throw new Error("Failed to update user data");
    }
};
exports.updateUserDetails = updateUserDetails;
const fetchwalletbalance = async (userId) => {
    try {
        const result = await db_1.sequelize.query('CALL Getuserwallet(:userId)', {
            replacements: { userId },
            type: sequelize_1.QueryTypes.RAW,
        });
        return result[0] || null;
    }
    catch (error) {
        console.error('Error getting user wallet', error);
        throw new Error('Failed to fetch user wallet');
    }
};
exports.fetchwalletbalance = fetchwalletbalance;
const fetchastrologerwalletdata = async (contact) => {
    try {
        const [walletSummary] = await db_1.sequelize.query(`
      SELECT 
        astrologer_share AS astrologer_earnings,
        0 AS total_withdrawals,
        wallet_balance AS remaining_balance
      FROM astrologer_wallet
      WHERE mobileNumber = :contact
      `, {
            replacements: { contact },
            type: sequelize_1.QueryTypes.SELECT
        });
        const dailyConversations = await db_1.sequelize.query(`
      SELECT 
        DATE(created_at) AS date,
        COUNT(*) AS total_conversations,
        ROUND(SUM(total_time) / 60, 2) AS total_chat_duration_minutes
      FROM astrologer_user_messages
      WHERE astrologer_number = :contact
      GROUP BY DATE(created_at)
      ORDER BY DATE(created_at) DESC
      `, {
            replacements: { contact },
            type: sequelize_1.QueryTypes.SELECT
        });
        const dailyEarnings = await db_1.sequelize.query(`
      SELECT 
        DATE(created_at) AS date,
        SUM(amount) AS daily_earning,
        SUM(amount * (1 - commission_percentage / 100)) AS astrologer_earning
      FROM astrologer_user_messages
      WHERE astrologer_number = :contact
      GROUP BY DATE(created_at)
      ORDER BY DATE(created_at) DESC
      `, {
            replacements: { contact },
            type: sequelize_1.QueryTypes.SELECT
        });
        return {
            astrologer_earnings: Number(walletSummary?.astrologer_earnings || 0),
            total_withdrawals: Number(walletSummary?.total_withdrawals || 0),
            remaining_balance: Number(walletSummary?.remaining_balance || 0),
            daily_conversations: dailyConversations,
            daily_earnings: dailyEarnings
        };
    }
    catch (error) {
        console.error('Error getting astrologer wallet:', error);
        throw new Error('Failed to fetch astrologer wallet');
    }
};
exports.fetchastrologerwalletdata = fetchastrologerwalletdata;
const UpdateAstroProfileImage = async (Profile_image, contact) => {
    try {
        await db_1.sequelize.query('CALL UpdateAstroProfileImage(:Profile_image, :contact)', {
            replacements: { Profile_image, contact },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        console.log("Error find in procedure.");
        throw new Error('Failed to update image.');
    }
};
exports.UpdateAstroProfileImage = UpdateAstroProfileImage;
// model for pooja
const fetchAllPoojas = async () => {
    try {
        const result = await db_1.sequelize.query('CALL GetallPooja()', {
            type: sequelize_1.QueryTypes.RAW,
        });
        return result || null;
    }
    catch (error) {
        console.error("Error in fetchAllPoojas:", error);
        throw new Error('Failed to fetch pooja.');
    }
};
exports.fetchAllPoojas = fetchAllPoojas;
// fetch pooja details
const fetchpoojadetails = async (Poojaid) => {
    try {
        const result = await db_1.sequelize.query('CALL GetPoojaDetails(:Poojaid)', {
            replacements: { Poojaid },
            type: sequelize_1.QueryTypes.RAW,
        });
        return result[0] || null;
    }
    catch (error) {
        console.error('Error getting user wallet', error);
        throw new Error('Failed to fetch user wallet');
    }
};
exports.fetchpoojadetails = fetchpoojadetails;
const fetchmarquee = async () => {
    try {
        const result = await db_1.sequelize.query('CALL GetLatestMarqueeBanner()', {
            type: sequelize_1.QueryTypes.RAW,
        });
        return result || null;
    }
    catch (error) {
        console.error('Error getting marquee text.', error);
        throw new Error('Failed to fetch maruee deatls');
    }
};
exports.fetchmarquee = fetchmarquee;
const fetchastrobank = async (astro_id) => {
    try {
        const result = await db_1.sequelize.query('CALL GetAstroBank(:astro_id)', {
            replacements: { astro_id },
            type: sequelize_1.QueryTypes.RAW,
        });
        return result[0] || null;
    }
    catch (error) {
        console.error('Error getting astro bank', error);
        throw new Error('Failed to fetch astrologer bank.');
    }
};
exports.fetchastrobank = fetchastrobank;
const updateAstroBank = async (astro_id, account_holder, bank_name, account_number, ifsc_code) => {
    try {
        await db_1.sequelize.query('CALL UpdateAstroBank(:astro_id, :account_holder, :bank_name, :account_number, :ifsc_code)', {
            replacements: {
                astro_id,
                account_holder,
                bank_name,
                account_number,
                ifsc_code
            },
            type: sequelize_1.QueryTypes.RAW,
        });
        return true;
    }
    catch (error) {
        console.error('Error updating astro bank', error);
        throw new Error('Failed to update astrologer bank.');
    }
};
exports.updateAstroBank = updateAstroBank;
const fetchusechathistory = async (Phone) => {
    try {
        const result = await db_1.sequelize.query('CALL GetTop8UserChats(:Phone)', {
            replacements: { Phone },
            type: sequelize_1.QueryTypes.RAW,
        });
        return result || null;
    }
    catch (error) {
        console.error('Error getting user chats', error);
        throw new Error('Failed to fetch User Chat history.');
    }
};
exports.fetchusechathistory = fetchusechathistory;
const fetchAstrologerInteractionHistory = async (astrologerId, fromDate, toDate, limit = 10, offset = 0) => {
    try {
        // Stored procedure with pagination
        const data = await db_1.sequelize.query('CALL GetAstrologerInteractions(:astrologerId, :fromDate, :toDate, :limit, :offset)', {
            replacements: { astrologerId, fromDate: fromDate || null, toDate: toDate || null, limit, offset },
            // type: QueryTypes.SELECT,
        });
        // return data[0] || []; 
        return Array.isArray(data) ? data : [];
    }
    catch (error) {
        console.error('Error fetching astrologer interaction history:', error);
        throw new Error('Failed to fetch astrologer interaction history');
    }
};
exports.fetchAstrologerInteractionHistory = fetchAstrologerInteractionHistory;
// ADMIN – fetch astrologer wallet balance list
const fetchAdminAstrologerWallets = async () => {
    try {
        const result = await db_1.sequelize.query(`
      SELECT 
        a.id AS astrologer_id,
        a.username,
        a.mobileNumber,
        IFNULL(w.total_earned, 0) AS total_earned,
        IFNULL(w.wallet_balance, 0) AS wallet_balance
      FROM astrologer a
      LEFT JOIN astrologer_wallet w 
        ON w.astrologer_id = a.id
      ORDER BY w.wallet_balance DESC
      `, {
            type: sequelize_1.QueryTypes.SELECT,
        });
        return result || [];
    }
    catch (error) {
        console.error('Error fetching admin astrologer wallets', error);
        throw new Error('Failed to fetch astrologer wallet data');
    }
};
exports.fetchAdminAstrologerWallets = fetchAdminAstrologerWallets;
