"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unverifyPanditById = exports.deletePanditById = exports.verifyPanditById = exports.getPanditById = exports.getAllPandits = exports.findPanditByContact = exports.createPanditAccount = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const createPanditAccount = async (username, email, passwordHash, address, gender, mobileNumber, pincode, state, PoojaSpecialist, languages, experience, education, description, profileImage) => {
    try {
        await db_1.sequelize.query(`CALL CreatePandit(
        :username,
        :email,
        :password,
        :address,
        :gender,
        :mobileNumber,
        :pincode,
        :state,
        :PoojaSpecialist,
        :languages,
        :experience,
        :education,
        :description,
        :profileImage
      )`, {
            replacements: {
                username,
                email,
                password: passwordHash,
                address,
                gender,
                mobileNumber,
                pincode,
                state,
                PoojaSpecialist,
                languages,
                experience,
                education,
                description,
                profileImage,
            },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        // console.error("Error creating pandit:", error);
        throw error;
    }
};
exports.createPanditAccount = createPanditAccount;
const findPanditByContact = async (contact) => {
    try {
        const result = await db_1.sequelize.query("CALL GetPanditWithContact(:contact)", { replacements: { contact }, type: sequelize_1.QueryTypes.SELECT });
        if (!result || result.length === 0)
            return null;
        return result[0];
    }
    catch (error) {
        // console.error("Error fetching pandit by contact:", error);
        throw error;
    }
};
exports.findPanditByContact = findPanditByContact;
const getAllPandits = async () => {
    try {
        const result = await db_1.sequelize.query("CALL GetAllPandits()", {
            type: sequelize_1.QueryTypes.SELECT,
        });
        // console.log("Raw result from GetAllPandits:", JSON.stringify(result, null, 2));
        // Extract pandits from nested structure and filter out metadata
        let data = Array.isArray(result) ? result : [result];
        // If first element is an object with numbered keys, extract values
        if (data[0] && typeof data[0] === "object" && !Array.isArray(data[0])) {
            data = Object.values(data[0]);
        }
        const pandits = data
            .filter((item) => item &&
            typeof item === "object" &&
            "id" in item &&
            !("fieldCount" in item))
            .map((item) => ({
            id: Number(item.id),
            username: item.username || "Unknown",
            email: item.email || "N/A",
            password: item.password || "",
            address: item.address || "N/A",
            gender: item.gender || "Other",
            mobileNumber: item.mobileNumber || item.phone || "N/A",
            pincode: item.pincode || "N/A",
            state: item.state || "N/A",
            PoojaSpecialist: item.PoojaSpecialist || item.pooja_specialist || "N/A",
            languages: item.languages || "N/A",
            experience: item.experience || "N/A",
            education: item.education || "N/A",
            description: item.description || "N/A",
            profileImage: item.profileImage || item.profile_image || "",
            is_verified: Number(item.is_verified || 0),
            created_at: item.created_at ? new Date(item.created_at) : new Date(),
            // identityProofType: item.identityProofType || item.identity_proof_type || "OTHER",
            // identityProof: item.identityProof || item.identity_proof || "",
        }));
        // console.log("Processed pandits in model:", JSON.stringify(pandits, null, 2));
        return pandits;
    }
    catch (error) {
        // console.error("Error fetching all pandits:", error);
        throw error;
    }
};
exports.getAllPandits = getAllPandits;
const getPanditById = async (id) => {
    try {
        const result = await db_1.sequelize.query("CALL GetPanditById(:id)", {
            replacements: { id },
            type: sequelize_1.QueryTypes.SELECT,
        });
        if (!result || result.length === 0)
            return null;
        return result[0];
    }
    catch (error) {
        throw error;
    }
};
exports.getPanditById = getPanditById;
const verifyPanditById = async (id) => {
    try {
        const [rows] = await db_1.sequelize.query("CALL VerifyPanditById(:id)", {
            replacements: { id },
        });
        // CALL ka response array hota hai → [{ affectedRows: 1 }]
        const affectedRows = rows?.[0]?.affectedRows || 0;
        return { affectedRows };
    }
    catch (error) {
        console.error("Error verifying pandit:", error);
        throw error;
    }
};
exports.verifyPanditById = verifyPanditById;
const deletePanditById = async (id) => {
    try {
        const [result] = await db_1.sequelize.query("DELETE FROM `Pandit` WHERE id = :id", // ✅ correct table name
        {
            replacements: { id },
            type: sequelize_1.QueryTypes.DELETE,
        });
        return { affectedRows: result?.affectedRows || result?.rowCount || 0 };
    }
    catch (error) {
        console.error("Error deleting pandit:", error);
        throw error;
    }
};
exports.deletePanditById = deletePanditById;
// Unverify pandit using stored procedure
const unverifyPanditById = async (id) => {
    try {
        const [rows] = await db_1.sequelize.query("CALL UnverifyPanditById(:id)", {
            replacements: { id },
        });
        // CALL ka response array hota hai → [{ affectedRows: 1 }]
        const affectedRows = rows?.[0]?.affectedRows || 0;
        return { affectedRows };
    }
    catch (error) {
        console.error("Error unverifying pandit:", error);
        throw error;
    }
};
exports.unverifyPanditById = unverifyPanditById;
