"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updatebpartnerPassword = exports.findbpartnerByContact = exports.createbpartnerAccount = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const createbpartnerAccount = async (name, Phone, passwordHash, coupon_code, email) => {
    try {
        await db_1.sequelize.query('CALL create_bpartner(:name, :PhoneNumber, :password, :email, :coupon_code )', {
            replacements: { name, PhoneNumber: Phone, password: passwordHash, coupon_code, email },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        console.error('Error creating user:', error);
        throw error;
    }
};
exports.createbpartnerAccount = createbpartnerAccount;
const findbpartnerByContact = async (contact) => {
    try {
        const result = await db_1.sequelize.query('CALL login_bpartner(:contact)', {
            replacements: { contact },
            type: sequelize_1.QueryTypes.SELECT,
        });
        const firstResult = result[0];
        if (!firstResult)
            return null;
        const user = firstResult[Object.keys(firstResult)[0]];
        return user ?? null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.findbpartnerByContact = findbpartnerByContact;
const updatebpartnerPassword = async (contact, hashedPassword) => {
    try {
        await db_1.sequelize.query('CALL update_bpartner_password(:contact, :password)', {
            replacements: { contact, password: hashedPassword },
            type: sequelize_1.QueryTypes.RAW,
        });
    }
    catch (error) {
        console.error('Error updating user password:', error);
        throw error;
    }
};
exports.updatebpartnerPassword = updatebpartnerPassword;
