"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAstrologerFreeSlot = exports.updateAstrologerFreeSlot = exports.getAstrologerFreeSlots = exports.addAstrologerFreeSlot = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const addAstrologerFreeSlot = async (astrologer_id, start_time, end_time, repeat_daily) => {
    return await db_1.sequelize.query(`
    INSERT INTO astrologer_free_slots
    (astrologer_id, start_time, end_time, repeat_daily)
    VALUES (
      :astrologer_id,
      STR_TO_DATE(:start_time, '%Y-%m-%d %H:%i'),
      STR_TO_DATE(:end_time, '%Y-%m-%d %H:%i'),
      :repeat_daily
    )
    `, {
        replacements: {
            astrologer_id,
            start_time,
            end_time,
            repeat_daily
        },
        type: sequelize_1.QueryTypes.INSERT
    });
};
exports.addAstrologerFreeSlot = addAstrologerFreeSlot;
const getAstrologerFreeSlots = async (astrologer_id) => {
    const result = await db_1.sequelize.query(`
    SELECT *
    FROM astrologer_free_slots
    WHERE astrologer_id = :astrologer_id
    ORDER BY start_time ASC
    `, {
        replacements: { astrologer_id },
        type: sequelize_1.QueryTypes.SELECT
    });
    return result;
};
exports.getAstrologerFreeSlots = getAstrologerFreeSlots;
const updateAstrologerFreeSlot = async (id, start_time, end_time, repeat_daily) => {
    return await db_1.sequelize.query(`
    UPDATE astrologer_free_slots
    SET
      start_time = STR_TO_DATE(:start_time, '%Y-%m-%d %H:%i'),
      end_time = STR_TO_DATE(:end_time, '%Y-%m-%d %H:%i'),
      repeat_daily = :repeat_daily
    WHERE id = :id
    `, {
        replacements: {
            id,
            start_time,
            end_time,
            repeat_daily
        },
        type: sequelize_1.QueryTypes.UPDATE
    });
};
exports.updateAstrologerFreeSlot = updateAstrologerFreeSlot;
const deleteAstrologerFreeSlot = async (id) => {
    return await db_1.sequelize.query(`
    DELETE FROM astrologer_free_slots
    WHERE id = :id
    `, {
        replacements: { id },
        type: sequelize_1.QueryTypes.DELETE
    });
};
exports.deleteAstrologerFreeSlot = deleteAstrologerFreeSlot;
