"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findAllbpartner = exports.findAdminById = void 0;
const db_1 = require("../config/db");
const sequelize_1 = require("sequelize");
const findAdminById = async (Adminid) => {
    try {
        const result = await db_1.sequelize.query('CALL GetadminWithId(:Adminid)', {
            replacements: { Adminid },
            type: sequelize_1.QueryTypes.SELECT,
        });
        const firstResult = result[0];
        if (!firstResult)
            return null;
        const admin = firstResult[Object.keys(firstResult)[0]];
        return admin ?? null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.findAdminById = findAdminById;
const findAllbpartner = async () => {
    try {
        const result = await db_1.sequelize.query('CALL GetAllBpartner()', {
            type: sequelize_1.QueryTypes.RAW,
        });
        const bpartner = Array.isArray(result) ? result : [];
        return bpartner ?? null;
    }
    catch (error) {
        console.error('Error fetching user by contact:', error);
        throw error;
    }
};
exports.findAllbpartner = findAllbpartner;
