"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Marquee = void 0;
const sequelize_1 = require("sequelize");
const db_1 = require("../config/db");
class Marquee extends sequelize_1.Model {
}
exports.Marquee = Marquee;
Marquee.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER.UNSIGNED,
        autoIncrement: true,
        primaryKey: true,
    },
    marquee_text: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: false,
    },
    banner: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: db_1.sequelize,
    tableName: "marquee_banners",
    timestamps: false, // kyunki table me sirf created_at hai
});
