"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.upload = void 0;
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const UPLOAD_DIR_ASTROPROFILE = '/home/backendnavambhaw/public_html/uploads';
const UPLOAD_DIR_USERPROFILE = '/home/backendnavambhaw/public_html/user_profile';
const UPLOAD_DIR_POOJAIMAGE = '/home/backendnavambhaw/public_html/pooja_image';
try {
    if (!fs_1.default.existsSync(UPLOAD_DIR_ASTROPROFILE)) {
        fs_1.default.mkdirSync(UPLOAD_DIR_ASTROPROFILE, { recursive: true });
    }
}
catch (error) {
    console.error('Error creating upload directory:', error);
}
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => {
        cb(null, UPLOAD_DIR_ASTROPROFILE);
    },
    filename: (req, file, cb) => {
        const uniqueName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${path_1.default.extname(file.originalname)}`;
        cb(null, uniqueName);
    }
});
const fileFilter = (req, file, cb) => {
    if (file.mimetype.startsWith('image/')) {
        cb(null, true);
    }
    else {
        cb(new Error('Only image files are allowed!'));
    }
};
exports.upload = (0, multer_1.default)({
    storage,
    fileFilter,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    }
});
