"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAdminAstrologerWallets = exports.getAstrologerInteractionHistory = exports.userchathistory = exports.updateAstrologerBank = exports.getastrobank = exports.getmarquee = exports.fetchpoojadata = exports.fetchallpoojas = exports.fetchastrowallet = exports.updateastroprofileimage = exports.fetchuserwallet = exports.fetchastrologerdeatils = exports.fetchuserdeatils = exports.fetchAllAstrologer = void 0;
const servicesModel_1 = require("../models/servicesModel");
const astrologerModel_1 = require("../models/astrologerModel");
const fetchAllAstrologer = async (req, res) => {
    try {
        const astrologers = await (0, servicesModel_1.fetchAllAstrologers)();
        res.status(200).json({ success: true, data: astrologers });
    }
    catch (error) {
        console.error('Error in /astrologers route:', error);
        res.status(500).json({ success: false, error: 'Failed to fetch astrologers' });
    }
};
exports.fetchAllAstrologer = fetchAllAstrologer;
const fetchuserdeatils = async (req, res) => {
    const { Phone } = req.body;
    try {
        const user = await (0, servicesModel_1.fetchuserdata)(Phone);
        res.status(200).json({ success: true, data: user });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch user deatils" });
    }
};
exports.fetchuserdeatils = fetchuserdeatils;
const fetchastrologerdeatils = async (req, res) => {
    const { Phone } = req.body;
    try {
        const user = await (0, servicesModel_1.fetchastrologerdata)(Phone);
        res.status(200).json({ success: true, data: user });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch astrologer deatils" });
    }
};
exports.fetchastrologerdeatils = fetchastrologerdeatils;
const fetchuserwallet = async (req, res) => {
    const { User_id } = req.query;
    const userId = Number(User_id);
    try {
        if (!User_id) {
            res.status(400).json({ success: false, error: "user_id is required" });
            return;
        }
        const data = await (0, servicesModel_1.fetchwalletbalance)(userId);
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch user deatils" });
    }
};
exports.fetchuserwallet = fetchuserwallet;
const updateastroprofileimage = async (req, res) => {
    const { Phone } = req.body;
    const Profile_image = req.file ? `https://backend.navambhaw.com/uploads/${req.file.filename}` : '';
    try {
        const astrologer = await (0, astrologerModel_1.findAstrologerByContact)(Phone);
        if (!astrologer) {
            res.status(404).json({ success: false, message: 'Astrologer with this phone number does not exist' });
            return;
        }
        await (0, servicesModel_1.UpdateAstroProfileImage)(Profile_image, Phone);
        res.status(200).json({ success: true, message: "Image Uploaded successfully." });
    }
    catch (error) {
        res.status(500).json({ success: false, message: "Internal server error." });
    }
};
exports.updateastroprofileimage = updateastroprofileimage;
const fetchastrowallet = async (req, res) => {
    const { Phone } = req.body;
    try {
        const wallet = await (0, servicesModel_1.fetchastrologerwalletdata)(Phone);
        res.status(200).json({ success: true, data: wallet });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch astrologer deatils" });
    }
};
exports.fetchastrowallet = fetchastrowallet;
const fetchallpoojas = async (req, res) => {
    try {
        const poojas = await (0, servicesModel_1.fetchAllPoojas)();
        res.status(200).json({ success: true, data: poojas });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch Pooja deatils" });
    }
};
exports.fetchallpoojas = fetchallpoojas;
// fetch one pooja data
const fetchpoojadata = async (req, res) => {
    const { pooja_id } = req.query;
    const Poojaid = Number(pooja_id);
    try {
        if (!Poojaid) {
            res.status(400).json({ success: false, error: "pooja_id is required" });
            return;
        }
        const data = await (0, servicesModel_1.fetchpoojadetails)(Poojaid);
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch user deatils" });
    }
};
exports.fetchpoojadata = fetchpoojadata;
const getmarquee = async (req, res) => {
    try {
        const data = await (0, servicesModel_1.fetchmarquee)();
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch marquee deatils" });
    }
};
exports.getmarquee = getmarquee;
const getastrobank = async (req, res) => {
    const { astrologer_id } = req.query;
    const astro_id = Number(astrologer_id);
    try {
        const data = await (0, servicesModel_1.fetchastrobank)(astro_id);
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to fetch bank deatils" });
    }
};
exports.getastrobank = getastrobank;
const updateAstrologerBank = async (req, res) => {
    const { astro_id, account_holder, bank_name, account_number, ifsc_code } = req.body;
    if (!astro_id || !account_holder || !bank_name || !account_number || !ifsc_code) {
        res.status(400).json({ success: false, message: 'All fields are required.' });
    }
    try {
        await (0, servicesModel_1.updateAstroBank)(astro_id, account_holder, bank_name, account_number, ifsc_code);
        res.status(200).json({ success: true, message: 'Bank details updated successfully.' });
    }
    catch (error) {
        res.status(500).json({ success: false, message: 'Failed to update bank details.' });
    }
};
exports.updateAstrologerBank = updateAstrologerBank;
const userchathistory = async (req, res) => {
    const { Phone } = req.query;
    try {
        const data = await (0, servicesModel_1.fetchusechathistory)(Phone);
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, error: "Failed to Chat History" });
    }
};
exports.userchathistory = userchathistory;
// export const getAstrologerInteractionHistory = async (
//   req: Request,
//   res: Response
// ): Promise<void> => {
//   const astrologerId = Number(req.query.astrologer_id);
//   const from = req.query.from as string | undefined;
//   const to = req.query.to as string | undefined;
//   // ✅ Validate astrologer_id
//   if (!astrologerId || isNaN(astrologerId)) {
//     res.status(400).json({
//       success: false,
//       message: 'Valid astrologer_id is required'
//     });
//     return;
//   }
//   try {
//     const data = await fetchAstrologerInteractionHistory(
//       astrologerId,
//       from,
//       to
//     );
//     res.status(200).json({
//       success: true,
//       count: data.length,
//       data
//     });
//   } catch (error) {
//     console.error(
//       'Error fetching astrologer interaction history:',
//       error
//     );
//     res.status(500).json({
//       success: false,
//       message: 'Failed to fetch astrologer interaction history'
//     });
//   }
// };
const getAstrologerInteractionHistory = async (req, res) => {
    try {
        const query = req.query;
        const astrologerId = Number(query.astrologer_id);
        const from = query.from;
        const to = query.to;
        const page = query.page ? parseInt(query.page, 10) : 1;
        const limit = 10;
        const offset = (page - 1) * limit;
        if (!astrologerId || isNaN(astrologerId)) {
            res.status(400).json({
                success: false,
                message: 'Valid astrologer_id is required',
            });
            return; // don't return res
        }
        const data = await (0, servicesModel_1.fetchAstrologerInteractionHistory)(astrologerId, from, to, limit, offset);
        // Ensure data is an array
        const dataArray = Array.isArray(data) ? data : [];
        res.status(200).json({
            success: true,
            page,
            limit,
            count: dataArray.length,
            data: dataArray,
        });
    }
    catch (error) {
        console.error('Error fetching astrologer interaction history:', error);
        res.status(500).json({
            success: false,
            message: 'Failed to fetch astrologer interaction history',
        });
    }
};
exports.getAstrologerInteractionHistory = getAstrologerInteractionHistory;
const servicesModel_2 = require("../models/servicesModel");
const getAdminAstrologerWallets = async (req, res) => {
    try {
        const data = await (0, servicesModel_2.fetchAdminAstrologerWallets)();
        res.status(200).json({
            success: true,
            count: data.length,
            data,
        });
    }
    catch (error) {
        console.error('Error fetching admin astrologer wallets:', error);
        res.status(500).json({
            success: false,
            message: 'Failed to fetch astrologer wallet list',
        });
    }
};
exports.getAdminAstrologerWallets = getAdminAstrologerWallets;
