"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dateAstrologerWiseAdminEarning = exports.todayAstrologerWiseAdminEarning = exports.adminEarningByDate = exports.dateWiseAdminEarning = exports.todayAdminEarning = exports.totalAdminEarning = exports.getAstrologerPayoutHistory = exports.payoutAstrologer = void 0;
const payoutModel_1 = require("../models/payoutModel");
const payoutAstrologer = async (req, res) => {
    try {
        const { astrologer_id, amount, payment_mode, reference_id, remarks, } = req.body;
        if (!astrologer_id || !amount || !payment_mode || !reference_id) {
            res.status(400).json({
                success: false,
                message: "Missing required fields",
            });
            return;
        }
        const data = await (0, payoutModel_1.payoutAstrologerAmount)({
            astrologer_id: Number(astrologer_id),
            amount: Number(amount),
            payment_mode,
            reference_id,
            remarks,
        });
        res.status(200).json({
            success: true,
            message: "Payout recorded successfully",
            data,
        });
    }
    catch (error) {
        res.status(400).json({
            success: false,
            message: error.message || "Failed to payout astrologer",
        });
    }
};
exports.payoutAstrologer = payoutAstrologer;
const getAstrologerPayoutHistory = async (req, res) => {
    try {
        const { astrologer_id } = req.params;
        if (!astrologer_id) {
            res.status(400).json({
                success: false,
                message: "Astrologer ID is required",
            });
            return;
        }
        const data = await (0, payoutModel_1.fetchAstrologerPayoutHistory)(Number(astrologer_id));
        res.status(200).json({
            success: true,
            count: data.length,
            data,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch payout history",
        });
    }
};
exports.getAstrologerPayoutHistory = getAstrologerPayoutHistory;
const payoutModel_2 = require("../models/payoutModel");
/**
 * 🔹 Total Admin Earning
 */
const totalAdminEarning = async (req, res) => {
    try {
        const amount = await (0, payoutModel_2.getTotalAdminEarning)();
        res.status(200).json({
            success: true,
            total_admin_earning: amount,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch total admin earning",
        });
    }
};
exports.totalAdminEarning = totalAdminEarning;
/**
 * 🔹 Today Admin Earning
 */
const todayAdminEarning = async (req, res) => {
    try {
        const amount = await (0, payoutModel_2.getTodayAdminEarning)();
        res.status(200).json({
            success: true,
            today_admin_earning: amount,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch today admin earning",
        });
    }
};
exports.todayAdminEarning = todayAdminEarning;
/**
 * 🔹 Date-wise Admin Earning
 */
const dateWiseAdminEarning = async (req, res) => {
    try {
        const data = await (0, payoutModel_2.getDateWiseAdminEarning)();
        res.status(200).json({
            success: true,
            count: data.length,
            data,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch date-wise earning",
        });
    }
};
exports.dateWiseAdminEarning = dateWiseAdminEarning;
/**
 * 🔹 Admin Earning by Date
 */
const adminEarningByDate = async (req, res) => {
    try {
        const { date } = req.params;
        if (!date) {
            res.status(400).json({
                success: false,
                message: "Date is required",
            });
            return;
        }
        const amount = await (0, payoutModel_2.getAdminEarningByDate)(date);
        res.status(200).json({
            success: true,
            date,
            admin_earning: amount,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch admin earning by date",
        });
    }
};
exports.adminEarningByDate = adminEarningByDate;
const todayAstrologerWiseAdminEarning = async (req, res) => {
    try {
        const data = await (0, payoutModel_2.getTodayAstrologerWiseAdminEarning)();
        res.status(200).json({
            success: true,
            date: new Date().toISOString().split("T")[0],
            count: data.length,
            data,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch astrologer-wise admin earning",
        });
    }
};
exports.todayAstrologerWiseAdminEarning = todayAstrologerWiseAdminEarning;
const dateAstrologerWiseAdminEarning = async (req, res) => {
    try {
        const { date } = req.params;
        if (!date) {
            res.status(400).json({
                success: false,
                message: "Date is required (YYYY-MM-DD)",
            });
            return;
        }
        const data = await (0, payoutModel_2.getDateAstrologerWiseAdminEarning)(date);
        res.status(200).json({
            success: true,
            date,
            count: data.length,
            data,
        });
    }
    catch (error) {
        res.status(500).json({
            success: false,
            message: error.message ||
                "Failed to fetch date-wise astrologer admin earning",
        });
    }
};
exports.dateAstrologerWiseAdminEarning = dateAstrologerWiseAdminEarning;
