"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unverifyPandit = exports.verifyPandit = exports.fetchPanditByPhone = exports.fetchPanditById = exports.fetchAllPandits = exports.registerPandit = void 0;
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const panditModel_1 = require("../models/panditModel");
const registerPandit = async (req, res) => {
    try {
        const { username, mobileNumber, email, address, pincode, state, PoojaSpecialist, languages, experience, education, description, gender, } = req.body;
        const files = req.files;
        //   : '';
        const profileImage = req.file
            ? `https://backend.navambhaw.com/uploads/${req.file.filename}`
            : '';
        const passwordHash = await bcryptjs_1.default.hash(req.body.password, 10);
        await (0, panditModel_1.createPanditAccount)(username, email, passwordHash, address, gender, mobileNumber, pincode, state, PoojaSpecialist, languages, experience, education, description, profileImage || "");
        res.status(201).json({
            success: true,
            message: "Pandit registered successfully",
        });
    }
    catch (error) {
        console.error("Error registering pandit:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.registerPandit = registerPandit;
// Baaki sab functions same rahenge
const fetchAllPandits = async (req, res) => {
    try {
        const pandits = await (0, panditModel_1.getAllPandits)();
        res.status(200).json({ success: true, data: pandits });
    }
    catch (error) {
        console.error("Error fetching all pandits:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.fetchAllPandits = fetchAllPandits;
const fetchPanditById = async (req, res) => {
    try {
        const { id } = req.params;
        const pandit = await (0, panditModel_1.getPanditById)(Number(id));
        if (!pandit) {
            res.status(404).json({ success: false, message: "Pandit not found" });
            return;
        }
        res.status(200).json({ success: true, data: pandit });
    }
    catch (error) {
        console.error("Error fetching pandit by id:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.fetchPanditById = fetchPanditById;
const fetchPanditByPhone = async (req, res) => {
    try {
        const { phone } = req.params;
        const pandit = await (0, panditModel_1.findPanditByContact)(phone);
        if (!pandit) {
            res.status(404).json({ success: false, message: "Pandit not found" });
            return;
        }
        res.status(200).json({ success: true, data: pandit });
    }
    catch (error) {
        console.error("Error fetching pandit by phone:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.fetchPanditByPhone = fetchPanditByPhone;
const verifyPandit = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await (0, panditModel_1.verifyPanditById)(Number(id));
        if (result.affectedRows === 0) {
            res.status(404).json({ success: false, message: "Pandit not found" });
            return;
        }
        res.status(200).json({ success: true, message: "Pandit verified successfully" });
    }
    catch (error) {
        console.error("Error verifying pandit:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.verifyPandit = verifyPandit;
const unverifyPandit = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await (0, panditModel_1.unverifyPanditById)(Number(id));
        if (result.affectedRows === 0) {
            res.status(404).json({ success: false, message: "Pandit not found" });
            return;
        }
        res.status(200).json({ success: true, message: "Pandit unverified successfully" });
    }
    catch (error) {
        console.error("Error unverifying pandit:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.unverifyPandit = unverifyPandit;
