"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numerotable = exports.kalsarpadetails = exports.horochartimaged9 = exports.horochartimaged1 = exports.basicpanchang = exports.alltimepancahng = exports.genralascendantreport = exports.currentvdasha = exports.timzonewithdst = exports.horochartd1 = exports.horochartd9 = exports.timezone = exports.geodetails = exports.ghatchakra = exports.planets = exports.birthdetails = exports.astrodeatils = void 0;
const axios_1 = __importDefault(require("axios"));
const dotenv_1 = __importDefault(require("dotenv"));
const mongoose_1 = __importDefault(require("mongoose"));
dotenv_1.default.config();
const now = new Date();
const timezone1 = -now.getTimezoneOffset() / 60;
const userId = process.env.userId;
const apiKey = process.env.apiKey;
const language = process.env.language;
const auth = 'Basic ' + Buffer.from(`${userId}:${apiKey}`).toString('base64');
const mongoURI = "mongodb+srv://ankitdonhai:MGQEJ1DUF7V1VSds@cluster0.ad27ekx.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0";
mongoose_1.default.connect(mongoURI, {
    serverSelectionTimeoutMS: 15000,
})
    .then(() => console.log("✅ MongoDB Connected"))
    .catch((err) => {
    console.error("❌ MongoDB connection error:", err.message);
});
const PanchangSchema = new mongoose_1.default.Schema({
    date: { type: Date, default: Date.now },
    day: String,
    tithi: String,
    nakshatra: String,
    yog: String,
    karan: String,
    sunrise: String,
    sunset: String,
    vedic_sunrise: String,
    vedic_sunset: String,
});
const astrodeatils = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/birth_details`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.astrodeatils = astrodeatils;
const birthdetails = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/astro_details`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.birthdetails = birthdetails;
const planets = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/planets`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.planets = planets;
const ghatchakra = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/get_chakra`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.ghatchakra = ghatchakra;
const geodetails = async (req, res) => {
    const { place } = req.body;
    const maxRows = 6;
    axios_1.default.post(`https://json.astrologyapi.com/v1/geo_details`, { place, maxRows }, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.geodetails = geodetails;
const timezone = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/timezone`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.timezone = timezone;
// nothing will happens with params it called for D9 everytime
const horochartd9 = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/horo_chart/D9`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.horochartd9 = horochartd9;
const horochartd1 = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/horo_chart/D1`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.horochartd1 = horochartd1;
// not subscribedd
const timzonewithdst = async (req, res) => {
    const data = req.body;
    const place = data.place;
    const date = `${data.day}-${data.month}-${data.year}`;
    const maxRows = 2;
    axios_1.default.post(`https://json.astrologyapi.com/v1/geo_details`, { place, maxRows }, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        // const latitude=response.data.geonames[0].latitude;
        // const longitude=response.data.geonames[0].longitude;
        const latitude = 19.23232;
        const longitude = 72.23234;
        console.log(latitude, longitude, date);
        axios_1.default.post(`https://json.astrologyapi.com/v1/timzone_with_dst`, { date, latitude, longitude }, {
            headers: {
                'Authorization': auth,
                'Content-Type': 'application/json',
                'Accept-Language': language,
            },
        })
            .then((response) => {
            console.log(response.data);
            res.status(200).json({ success: true, message: response.data });
        });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.timzonewithdst = timzonewithdst;
const currentvdasha = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/current_vdasha`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.currentvdasha = currentvdasha;
const genralascendantreport = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/general_ascendant_report`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.genralascendantreport = genralascendantreport;
const alltimepancahng = async (req, res) => {
    const currentDetails = req.body;
    console.log(currentDetails);
    axios_1.default.post(`https://json.astrologyapi.com/v1/basic_panchang`, currentDetails, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.log(error);
        res.status(400).json({ success: false, message: error });
    });
};
exports.alltimepancahng = alltimepancahng;
const basicpanchang = async (req, res) => {
    try {
        const Panchang = mongoose_1.default.model('Panchang', PanchangSchema);
        const latestPanchang = await Panchang.findOne().sort({ date: -1 });
        if (!latestPanchang) {
            res.status(404).json({ success: false, message: "No Panchang data found" });
            return;
        }
        res.status(200).json({ success: true, message: latestPanchang });
    }
    catch (error) {
        console.error("DB fetch error:", error);
        res.status(500).json({ success: false, message: "Failed to fetch Panchang data" });
    }
};
exports.basicpanchang = basicpanchang;
// nothing will happens with params it called for D9 everytime
const horochartimaged1 = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/horo_chart_image/D1`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.horochartimaged1 = horochartimaged1;
const horochartimaged9 = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/horo_chart_image/D9`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.horochartimaged9 = horochartimaged9;
const kalsarpadetails = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/kalsarpa_details`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.kalsarpadetails = kalsarpadetails;
const numerotable = async (req, res) => {
    const data = req.body;
    axios_1.default.post(`https://json.astrologyapi.com/v1/numero_table`, data, {
        headers: {
            'Authorization': auth,
            'Content-Type': 'application/json',
            'Accept-Language': language,
        },
    })
        .then((response) => {
        console.log(response.data);
        res.status(200).json({ success: true, message: response.data });
    })
        .catch((error) => {
        console.error(error.response ? error.response.data : error.message);
        res.status(400).json({ success: false, message: error });
    });
};
exports.numerotable = numerotable;
