"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteFreeSlot = exports.updateFreeSlot = exports.getFreeSlots = exports.addFreeSlot = void 0;
const astrologerFreeSlotModel_1 = require("../models/astrologerFreeSlotModel");
const addFreeSlot = async (req, res) => {
    try {
        const { astrologer_id, start_time, end_time, repeat_daily } = req.body;
        if (!astrologer_id || !start_time || !end_time) {
            res.status(400).json({ success: false, message: 'Required fields missing' });
            return;
        }
        await (0, astrologerFreeSlotModel_1.addAstrologerFreeSlot)(astrologer_id, start_time, end_time, repeat_daily ? 1 : 0);
        res.status(200).json({
            success: true,
            message: 'Free slot added successfully'
        });
    }
    catch (error) {
        console.error(error);
        res.status(500).json({ success: false, message: 'Failed to add slot' });
    }
};
exports.addFreeSlot = addFreeSlot;
const getFreeSlots = async (req, res) => {
    try {
        const astrologer_id = Number(req.query.astrologer_id);
        if (!astrologer_id) {
            res.status(400).json({ success: false, message: 'astrologer_id required' });
            return;
        }
        const data = await (0, astrologerFreeSlotModel_1.getAstrologerFreeSlots)(astrologer_id);
        res.status(200).json({ success: true, data });
    }
    catch (error) {
        res.status(500).json({ success: false, message: 'Failed to fetch slots' });
    }
};
exports.getFreeSlots = getFreeSlots;
const updateFreeSlot = async (req, res) => {
    try {
        const { id, start_time, end_time, repeat_daily } = req.body;
        await (0, astrologerFreeSlotModel_1.updateAstrologerFreeSlot)(id, start_time, end_time, repeat_daily ? 1 : 0);
        res.status(200).json({
            success: true,
            message: 'Slot updated successfully'
        });
    }
    catch (error) {
        res.status(500).json({ success: false, message: 'Failed to update slot' });
    }
};
exports.updateFreeSlot = updateFreeSlot;
const deleteFreeSlot = async (req, res) => {
    try {
        const id = Number(req.query.id);
        await (0, astrologerFreeSlotModel_1.deleteAstrologerFreeSlot)(id);
        res.status(200).json({
            success: true,
            message: 'Slot deleted successfully'
        });
    }
    catch (error) {
        res.status(500).json({ success: false, message: 'Failed to delete slot' });
    }
};
exports.deleteFreeSlot = deleteFreeSlot;
