"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllAstrologersWithPriceCommission = exports.toggleFreeStatusByMobile = exports.getAllAstrologers = exports.fetchAstrologerPriceCommission = exports.setAstrologerPriceCommission = exports.unverifyAstrologerController = exports.verifyAstrologerController = exports.updateastropass = exports.Forgotpass = exports.FrogotpassendOTP = exports.Login = exports.Register = exports.Sendotp = void 0;
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const astrologerModel_1 = require("../models/astrologerModel");
const userModel_1 = require("../models/userModel");
const bpartnerModel_1 = require("../models/bpartnerModel");
const otpStore_1 = require("../otpStore/otpStore");
const dotenv_1 = __importDefault(require("dotenv"));
const axios_1 = __importDefault(require("axios"));
const inmemoery_1 = require("../services/inmemoery");
dotenv_1.default.config();
const JWT_SECRET = process.env.JWT_SECRET;
if (!JWT_SECRET) {
    throw new Error('JWT_SECRET is not defined');
}
async function sendSMS(Phone, message) {
    const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';
    const params = {
        key: '467DD867AC81DD',
        campaign: '0',
        routeid: '13',
        type: 'text',
        contacts: Phone,
        senderid: 'MOJIJA',
        msg: message,
        template_id: '1707174402396213814'
    };
    try {
        const response = await axios_1.default.get(url, { params });
        console.log(`SMS sent to ${Phone}:`, response.data);
    }
    catch (error) {
        console.error(`Failed to send SMS to ${Phone}:`, error);
        throw new Error('Failed to send SMS');
    }
}
async function sendSMS2(Phone, message) {
    const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';
    const params = {
        key: '467DD867AC81DD',
        campaign: '0',
        routeid: '13',
        type: 'text',
        contacts: Phone,
        senderid: 'MOJIJA',
        msg: message,
        template_id: '1707174774488064756'
    };
    try {
        const response = await axios_1.default.get(url, { params });
        console.log(`SMS sent to ${Phone}:`, response.data);
    }
    catch (error) {
        console.error(`Failed to send SMS to ${Phone}:`, error);
        throw new Error('Failed to send SMS');
    }
}
const Sendotp = async (req, res) => {
    const Phone = req.body.Phone || req.body.phone;
    if (!Phone) {
        res.status(400).json({ success: false, message: "Phone number required" });
        return;
    }
    const otp = Math.floor(100000 + Math.random() * 900000).toString();
    await (0, otpStore_1.setOtp)(Phone, otp);
    await sendSMS(Phone, `${otp} is your Login OTP. Do not share it with anyone Regards MOJIJA.`);
    console.log(otp);
    // console.log(`OTP for ${phone}: ${otp}`);
    res.json({ success: true, message: "OTP sent successfully" });
};
exports.Sendotp = Sendotp;
const Register = async (req, res) => {
    const { Astrologer_name, Phone, Email, Address, Pincode, State, Specialization, Languages, Experience, Highest_qualification, Description, Password, otp } = req.body;
    if (!Astrologer_name || !Phone || !Email || !Address || !Pincode || !State ||
        !Specialization || !Languages || !Experience || !Highest_qualification ||
        !Description || !Password || !otp) {
        res.status(400).json({ success: false, message: "All fields are required." });
        return;
    }
    // const storedOtp = await getOtp(Phone);
    const otpStr = await (0, otpStore_1.getOtp)(Phone);
    const storedOtpStr = otpStr ? String(otpStr).trim() : null;
    const storedOtp = otp ? otp.trim() : null;
    if (!storedOtp || storedOtp !== storedOtpStr) {
        res.status(400).json({ success: false, message: "Invalid or expired OTP." });
        return;
    }
    try {
        // Check for existing astrologer
        const existingAstrologer = await (0, astrologerModel_1.findAstrologerByContact)(Phone);
        if (existingAstrologer && existingAstrologer.id) {
            res.status(400).json({ success: false, message: "An astrologer already exists with this phone number." });
            return;
        }
        const existingUser = await (0, userModel_1.findUserByContact)(Phone);
        if (existingUser && existingUser.id) {
            res.status(400).json({ success: false, message: "A User already exists with this phone number." });
            return;
        }
        const exsitingbpartner = await (0, bpartnerModel_1.findbpartnerByContact)(Phone);
        if (exsitingbpartner && exsitingbpartner.id) {
            res.status(400).json({ success: false, message: "A Business Partner already exists with this phone number." });
            return;
        }
        const passwordHash = await bcryptjs_1.default.hash(Password, 10);
        const Profile_image = req.file
            ? `https://backend.navambhaw.com/uploads/${req.file.filename}` : '';
        await (0, astrologerModel_1.createAstrologerAccount)(Astrologer_name, Phone, Email, Address, Pincode, State, Specialization, Languages, Experience, Highest_qualification, Description, Profile_image, passwordHash);
        const newAstrologer = await (0, astrologerModel_1.findAstrologerByContact)(Phone);
        if (!newAstrologer) {
            res.status(500).json({ success: false, message: "Failed to create astrologer." });
            return;
        }
        await (0, otpStore_1.deleteOtp)(Phone);
        res.json({
            success: true,
            message: "Astrologer registered successfully.",
        });
    }
    catch (error) {
        console.error("Registration error:", error);
        res.status(500).json({ success: false, message: "Internal server error." });
    }
};
exports.Register = Register;
const Login = async (req, res) => {
    const { Phone, Password, otp } = req.body;
    if (!Phone || !Password || !otp) {
        res.status(400).json({ success: false, message: 'Phone, password and otp are required' });
        return;
    }
    try {
        const astrologer = await (0, astrologerModel_1.findAstrologerByContact)(Phone);
        if (!astrologer) {
            res.status(404).json({ success: false, message: 'Astrologer not found' });
            return;
        }
        if (!astrologer.password) {
            res.status(500).json({ success: false, message: 'Astrologer password not found' });
            return;
        }
        const alreadylogin = await (0, inmemoery_1.getastro)(Phone);
        if (alreadylogin) {
            res.status(400).json({ success: false, message: "Astorloger is already log in." });
            return;
        }
        const otpStr = await (0, otpStore_1.getOtp)(Phone);
        const storedOtpStr = otpStr ? String(otpStr).trim() : null;
        const storedOtp = otp ? otp.trim() : null;
        if (!storedOtp || storedOtp !== storedOtpStr) {
            res.status(400).json({ success: false, message: "Invalid or expired OTP." });
            return;
        }
        const isMatch = await bcryptjs_1.default.compare(Password, astrologer.password);
        if (!isMatch) {
            res.status(401).json({ success: false, message: 'Invalid credentials' });
            return;
        }
        console.log("token has been send.");
        const token = jsonwebtoken_1.default.sign({ id: astrologer.id, name: astrologer.Astrologer_name }, JWT_SECRET, { expiresIn: "7d" });
        await (0, otpStore_1.deleteOtp)(Phone);
        res.cookie('token', token, {
            httpOnly: false,
            secure: process.env.NODE_ENV === 'production', // use true in production with HTTPS
            sameSite: 'none',
            maxAge: 7 * 24 * 60 * 60 * 1000
        });
        const { password, ...astroWithoutPassword } = astrologer;
        res.status(200).json({ success: true, message: 'Login successful', astrologer: astroWithoutPassword });
    }
    catch (error) {
        console.error('Login error:', error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
};
exports.Login = Login;
const FrogotpassendOTP = async (req, res) => {
    const { Phone } = req.body;
    if (!Phone) {
        res.status(400).json({ success: false, message: 'Phone number is required' });
        return;
    }
    try {
        const astrologer = await (0, astrologerModel_1.findAstrologerByContact)(Phone);
        if (!astrologer) {
            res.status(404).json({ success: false, message: 'Astrologer with this phone number does not exist' });
            return;
        }
        const otp = Math.floor(100000 + Math.random() * 900000).toString();
        await (0, otpStore_1.setOtp)(Phone, otp);
        await sendSMS2(Phone, `${otp} is your password reset OTP. Do not share it with anyone Regards MOJIJA.`);
        res.json({ success: true, message: 'OTP sent successfully' });
    }
    catch (error) {
        console.error('Error sending OTP:', error);
        res.status(500).json({ success: false, message: 'Internal server error' });
    }
};
exports.FrogotpassendOTP = FrogotpassendOTP;
const Forgotpass = async (req, res) => {
    const { newPassword, otp, Phone } = req.body;
    // const Phone: string = req.body.Phone
    console.log(newPassword, otp, Phone);
    if (!Phone || !newPassword) {
        res.status(400).json({ success: false, message: 'New password and OTP are required!' });
        return;
    }
    const otpStr = await (0, otpStore_1.getOtp)(Phone);
    const storedOtpStr = otpStr ? String(otpStr).trim() : null;
    const storedOtp = otp ? otp.trim() : null;
    if (!storedOtp || storedOtp !== storedOtpStr) {
        res.status(400).json({ success: false, message: 'Invalid or expired OTP' });
        return;
    }
    try {
        const hashedPassword = await bcryptjs_1.default.hash(newPassword, 10);
        await (0, astrologerModel_1.updateAstrologerPassword)(Phone, hashedPassword);
        await (0, otpStore_1.deleteOtp)(Phone);
        console.log("Password updated successfully for astrologer with phone:", Phone);
        res.json({ success: true, message: 'Password updated successfully' });
    }
    catch (error) {
        console.error('Error updating password:', error);
        res.status(500).json({ success: false, message: 'Internal server error' });
    }
};
exports.Forgotpass = Forgotpass;
const updateastropass = async (req, res) => {
    const { new_password, current_password, user_id } = req.body;
    const astro_id = Number(user_id);
    if (!astro_id || !current_password || !new_password) {
        res.status(400).json({ success: false, message: 'New password and Old one are required!' });
    }
    try {
        await (0, astrologerModel_1.updateAstrorPass)(astro_id, current_password, new_password);
        res.json({ success: true, message: 'Password updated successfully' });
    }
    catch (error) {
        console.error('Error updating password:', error);
        res.status(500).json({ success: false, message: 'Internal server error' });
    }
};
exports.updateastropass = updateastropass;
// ✅ Verify astrologer controller
const verifyAstrologerController = async (req, res) => {
    try {
        const { id } = req.params;
        await (0, astrologerModel_1.verifyAstrologer)(Number(id));
        res.status(200).json({ message: "Astrologer verified successfully" });
    }
    catch (error) {
        console.error("Verify Error:", error);
        res.status(500).json({ error: "Failed to verify astrologer" });
    }
};
exports.verifyAstrologerController = verifyAstrologerController;
// ✅ Unverify astrologer controller
const unverifyAstrologerController = async (req, res) => {
    try {
        const { id } = req.params;
        await (0, astrologerModel_1.unverifyAstrologer)(Number(id));
        res.status(200).json({ message: "Astrologer unverified successfully" });
    }
    catch (error) {
        console.error("Unverify Error:", error);
        res.status(500).json({ error: "Failed to unverify astrologer" });
    }
};
exports.unverifyAstrologerController = unverifyAstrologerController;
// 🔹 Update astrologer price & commission
const setAstrologerPriceCommission = async (req, res) => {
    try {
        const { astro_id, price, commission_percentage } = req.body;
        if (!astro_id || price == null || commission_percentage == null) {
            res.status(400).json({ success: false, message: "Missing fields" });
            return;
        }
        await (0, astrologerModel_1.updateAstrologerPriceAndCommission)(Number(astro_id), Number(price), Number(commission_percentage));
        res.json({
            success: true,
            message: "Astrologer price & commission updated successfully",
        });
    }
    catch (error) {
        console.error("Error in setAstrologerPriceCommission:", error);
        res.status(500).json({ success: false, message: "Internal server error" });
    }
};
exports.setAstrologerPriceCommission = setAstrologerPriceCommission;
// 🔹 Fetch astrologer price & commission
const fetchAstrologerPriceCommission = async (req, res) => {
    try {
        const { astro_id } = req.params;
        if (!astro_id) {
            res.status(400).json({ success: false, message: "Astrologer ID required" });
            return;
        }
        const result = await (0, astrologerModel_1.getAstrologerPriceAndCommission)(Number(astro_id));
        if (!result) {
            res.status(404).json({ success: false, message: "Astrologer not found" });
            return;
        }
        res.json({ success: true, data: result });
    }
    catch (error) {
        console.error("Error in fetchAstrologerPriceCommission:", error);
        res.status(500).json({ success: false, message: "Internal server error" });
    }
};
exports.fetchAstrologerPriceCommission = fetchAstrologerPriceCommission;
// 🔹 Get all astrologers
const getAllAstrologers = async (req, res) => {
    try {
        const astrologers = await (0, astrologerModel_1.fetchAllAstrologers)();
        res.status(200).json({
            success: true,
            data: astrologers,
        });
    }
    catch (error) {
        console.error("Error in getAllAstrologers:", error);
        res.status(500).json({
            success: false,
            message: "Failed to fetch astrologers",
            error: error.message,
        });
    }
};
exports.getAllAstrologers = getAllAstrologers;
const toggleFreeStatusByMobile = async (req, res) => {
    try {
        const { mobileNumber } = req.body;
        if (!mobileNumber || mobileNumber.toString().length < 10) {
            res.status(400).json({ success: false, message: "Valid mobile number required" });
            return;
        }
        const updatedAstro = await (0, astrologerModel_1.toggleAstrologerFreeStatusByMobile)(mobileNumber.toString());
        if (!updatedAstro) {
            res.status(404).json({ success: false, message: "Astrologer not found" });
            return;
        }
        res.json({
            success: true,
            message: updatedAstro.is_free === 1 ? "Astrologer is now FREE" : "Astrologer is now PAID",
            data: {
                id: updatedAstro.id,
                mobileNumber: updatedAstro.mobileNumber,
                username: updatedAstro.username || "Astrologer",
                is_free: updatedAstro.is_free,
                price: updatedAstro.price,
                original_price: updatedAstro.original_price || null,
            },
        });
    }
    catch (error) {
        console.error("Toggle free error:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Server error",
        });
    }
};
exports.toggleFreeStatusByMobile = toggleFreeStatusByMobile;
const getAllAstrologersWithPriceCommission = async (req, res) => {
    try {
        const astrologers = await (0, astrologerModel_1.fetchAllAstrologersWithPriceCommission)();
        res.status(200).json({
            success: true,
            data: astrologers,
        });
    }
    catch (error) {
        console.error("Error in getAllAstrologersWithPriceCommission:", error);
        res.status(500).json({
            success: false,
            message: "Failed to fetch astrologers",
            error: error.message,
        });
    }
};
exports.getAllAstrologersWithPriceCommission = getAllAstrologersWithPriceCommission;
