"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logout = exports.fetchBpartner = exports.Login = void 0;
const adminModel_1 = require("../models/adminModel");
const Login = async (req, res) => {
    const { Adminid, Password } = req.body;
    if (!Adminid || !Password) {
        res.status(400).json({ success: false, message: 'Phone and password are required' });
        return;
    }
    try {
        const admin = await (0, adminModel_1.findAdminById)(Adminid);
        if (!admin) {
            res.status(404).json({ success: false, message: 'User not found' });
            return;
        }
        if (!admin.password) {
            res.status(500).json({ success: false, message: 'User password not found' });
            return;
        }
        if (!(Password === admin.password)) {
            res.status(401).json({ success: false, message: 'Invalid credentials' });
            return;
        }
        const { password, ...adminWithoutPassword } = admin;
        res.status(200).json({ success: true, message: 'Login successful', admin: adminWithoutPassword });
    }
    catch (error) {
        console.error('Login error:', error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
};
exports.Login = Login;
const fetchBpartner = async (req, res) => {
    try {
        const Bpartner = await (0, adminModel_1.findAllbpartner)();
        res.status(200).json({ success: true, data: Bpartner });
    }
    catch (error) {
        console.error('Error in /astrologers route:', error);
        res.status(500).json({ success: false, error: 'Failed to fetch astrologers' });
    }
};
exports.fetchBpartner = fetchBpartner;
// ✅ Logout
const Logout = async (req, res) => {
    try {
        res.clearCookie("token", {
            httpOnly: true,
            sameSite: "none",
            secure: process.env.NODE_ENV === "production",
        });
        res.status(200).json({ success: true, message: "Logged out successfully" });
    }
    catch (error) {
        console.error("Logout error:", error);
        res.status(500).json({ success: false, message: "Server error" });
    }
};
exports.Logout = Logout;
