"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteMarquee = exports.updateMarquee = exports.addMarquee = exports.fetchAllMarquees = void 0;
const MarqueeModel_1 = require("../models/MarqueeModel");
// ✅ Get all marquees
const fetchAllMarquees = async (req, res) => {
    try {
        const marquees = await MarqueeModel_1.Marquee.findAll({ order: [["created_at", "DESC"]] });
        res.status(200).json({ success: true, data: marquees });
    }
    catch (error) {
        console.error("Error fetching marquees:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.fetchAllMarquees = fetchAllMarquees;
// ✅ Add new marquee
const addMarquee = async (req, res) => {
    try {
        const { marquee_text, banner } = req.body;
        await MarqueeModel_1.Marquee.create({ marquee_text, banner: banner || null });
        res.status(201).json({ success: true, message: "Marquee added successfully" });
    }
    catch (error) {
        console.error("Error adding marquee:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.addMarquee = addMarquee;
// ✅ Update marquee
const updateMarquee = async (req, res) => {
    try {
        const { id } = req.params;
        const { marquee_text, banner } = req.body;
        const marquee = await MarqueeModel_1.Marquee.findByPk(Number(id));
        if (!marquee) {
            res.status(404).json({ success: false, message: "Marquee not found" });
            return;
        }
        await marquee.update({ marquee_text, banner: banner || null });
        res.status(200).json({ success: true, message: "Marquee updated successfully" });
    }
    catch (error) {
        console.error("Error updating marquee:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.updateMarquee = updateMarquee;
// ✅ Delete marquee
const deleteMarquee = async (req, res) => {
    try {
        const { id } = req.params;
        const marquee = await MarqueeModel_1.Marquee.findByPk(Number(id));
        if (!marquee) {
            res.status(404).json({ success: false, message: "Marquee not found" });
            return;
        }
        await marquee.destroy();
        res.status(200).json({ success: true, message: "Marquee deleted successfully" });
    }
    catch (error) {
        console.error("Error deleting marquee:", error);
        res.status(500).json({ success: false, message: error.message });
    }
};
exports.deleteMarquee = deleteMarquee;
