"use strict";
// import express from 'express';
// import { ErrorRequestHandler } from 'express';
// import dotenv from 'dotenv';
// import useragent from 'express-useragent';
// import cors from 'cors';
// import astrologerRoute from './routes/astrologerRoutes';
// import userRoute from './routes/userRoutes';
// import bpartnerRoute from './routes/bpartnerRoutes';
// import servicesRoute from './routes/servicesRoutes';
// import adminRoute from './routes/adminRoutes';
// import kundaliapi from './routes/kundaliapi';
// import marqueeRoutes from "./routes/marqueeRoutes";
// import panditRoute from "./routes/panditRoutes";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// dotenv.config();
// const app = express();
// app.use(cors({
//   // origin: '*', 
//     origin: ["http://localhost:5173", "https://localhost:5173"],
//   credentials: true,               
// }));
// app.use(useragent.express());
// app.use(express.json());
// app.use(express.urlencoded({ extended: true }));
// // Health check endpoint for Vercel
// app.get('/health', (req, res) => {
//   res.status(200).json({ 
//     status: 'OK', 
//     message: 'Server is running',
//     timestamp: new Date().toISOString()
//   });
// });
// app.use((req, res, next) => {
// // console.log(JSON.stringify({
// //   time: new Date().toISOString(),
// //   method: req.method,
// //   path: req.url,
// //   ip: req.ip,
// //   userAgent: req.headers['user-agent']
// // }));
//   next();
// });
// // Static file serving - using relative paths for Vercel
// app.use('/uploads', express.static('./uploads'));
// app.use('/pooja_image', express.static('./pooja_image'));
// app.use('/user_profile', express.static('./user_profile'));
// app.use('/api/auth/astrologer', astrologerRoute);
// app.use('/api/auth/user', userRoute);
// app.use('/api/auth/bpartner', bpartnerRoute);
// app.use('/api/auth/admin', adminRoute);
// app.use('/v1', servicesRoute);
// app.use('/v2', kundaliapi);
// app.use("/api/auth/pandit", panditRoute);
// app.use("/api/marquee", marqueeRoutes);
// const errorHandler: ErrorRequestHandler = (err: any, req: express.Request, res: express.Response, next: express.NextFunction) => {
//   if (err instanceof SyntaxError && 'body' in err) {
//     res.status(400).json({
//       success: false,
//       message: 'Invalid JSON format in request body'
//     });
//     return;
//   }
//   next(err);
// };
// app.use(errorHandler);
// export default app;
const express_1 = __importDefault(require("express"));
const dotenv_1 = __importDefault(require("dotenv"));
const express_useragent_1 = __importDefault(require("express-useragent"));
require("./services/freeSlotsCron");
// Routes
const astrologerRoutes_1 = __importDefault(require("./routes/astrologerRoutes"));
const userRoutes_1 = __importDefault(require("./routes/userRoutes"));
const bpartnerRoutes_1 = __importDefault(require("./routes/bpartnerRoutes"));
const servicesRoutes_1 = __importDefault(require("./routes/servicesRoutes"));
const adminRoutes_1 = __importDefault(require("./routes/adminRoutes"));
const kundaliapi_1 = __importDefault(require("./routes/kundaliapi"));
const marqueeRoutes_1 = __importDefault(require("./routes/marqueeRoutes"));
const panditRoutes_1 = __importDefault(require("./routes/panditRoutes"));
const yogaTrainerRoutes_1 = __importDefault(require("./routes/yogaTrainerRoutes"));
const astrologerFreeSlotRoutes_1 = __importDefault(require("./routes/astrologerFreeSlotRoutes"));
const payoutRoutes_1 = __importDefault(require("./routes/payoutRoutes"));
dotenv_1.default.config();
const app = (0, express_1.default)();
// --------------------------------------
//  FIXED CORS (Manual like in dist code)
// --------------------------------------
const allowedOrigins = [
    "https://navambhaw.com",
    "https://www.navambhaw.com",
    "https://localhost:5173",
    "http://localhost:5173",
];
app.use((req, res, next) => {
    const origin = req.headers.origin;
    if (allowedOrigins.includes(origin)) {
        res.header("Access-Control-Allow-Origin", origin);
    }
    res.header("Access-Control-Allow-Credentials", "true");
    res.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
    res.header("Access-Control-Allow-Headers", "Content-Type, Authorization, X-Requested-With");
    if (req.method === "OPTIONS") {
        res.sendStatus(200);
        return; // important for TS
    }
    next();
});
// ----------------------------
// Middlewares
// ----------------------------
app.use(express_useragent_1.default.express());
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
// Health Check
app.get("/health", (req, res) => {
    res.status(200).json({
        status: "OK",
        message: "Server is running",
        timestamp: new Date().toISOString(),
    });
});
// Static files
app.use("/uploads", express_1.default.static("./uploads"));
app.use("/pooja_image", express_1.default.static("./pooja_image"));
app.use("/user_profile", express_1.default.static("./user_profile"));
// API Routes
app.use("/api/auth/astrologer", astrologerRoutes_1.default);
app.use("/api/auth/user", userRoutes_1.default);
app.use("/api/auth/bpartner", bpartnerRoutes_1.default);
app.use("/api/auth/admin", adminRoutes_1.default);
app.use("/v1", servicesRoutes_1.default);
app.use("/v2", kundaliapi_1.default);
app.use("/api/auth/pandit", panditRoutes_1.default);
app.use("/api/marquee", marqueeRoutes_1.default);
app.use('/api/auth/yoga', yogaTrainerRoutes_1.default);
app.use('/api/astrologer/free-slots', astrologerFreeSlotRoutes_1.default);
app.use("/v3", payoutRoutes_1.default);
// ----------------------------
// Error Handler
// ----------------------------
const errorHandler = (err, req, res, next) => {
    if (err instanceof SyntaxError && "body" in err) {
        res.status(400).json({
            success: false,
            message: "Invalid JSON format in request body",
        });
        return;
    }
    next(err);
};
app.use(errorHandler);
exports.default = app;
