"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = handler;
const axios_1 = __importDefault(require("axios"));
const mongoose_1 = __importDefault(require("mongoose"));
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
// MongoDB Schema
const PanchangSchema = new mongoose_1.default.Schema({
    date: { type: Date, default: Date.now },
    day: String,
    tithi: String,
    nakshatra: String,
    yog: String,
    karan: String,
    sunrise: String,
    sunset: String,
    vedic_sunrise: String,
    vedic_sunset: String,
});
const Panchang = mongoose_1.default.model('Panchang', PanchangSchema);
async function handler(req, res) {
    // Only allow POST requests
    if (req.method !== 'POST') {
        return res.status(405).json({ error: 'Method not allowed' });
    }
    // Verify the request is from Vercel Cron
    const authHeader = req.headers.authorization;
    if (authHeader !== `Bearer ${process.env.CRON_SECRET}`) {
        return res.status(401).json({ error: 'Unauthorized' });
    }
    try {
        // Connect to MongoDB
        const MONGODB_URI = process.env.MONGODB_URI || "mongodb+srv://ankitdonhai:MGQEJ1DUF7V1VSds@cluster0.ad27ekx.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0";
        await mongoose_1.default.connect(MONGODB_URI);
        console.log('Connected to MongoDB');
        const now = new Date();
        console.log('Fetching Panchang at:', now.toISOString());
        const requestBody = {
            day: now.getDate(),
            month: now.getMonth() + 1,
            year: now.getFullYear(),
            hour: 7,
            min: 15,
            lat: 28.6139,
            lon: 77.2090,
            tzone: 5.5
        };
        // Fetch panchang data
        const response = await axios_1.default.post('https://backend.navambhaw.com/v2/alltimepanchang', requestBody);
        const data = response.data.message;
        // Save to database
        const saved = await Panchang.create(data);
        console.log("Panchang saved:", saved._id);
        // Close MongoDB connection
        await mongoose_1.default.connection.close();
        return res.status(200).json({
            success: true,
            message: 'Panchang fetched and saved successfully',
            panchangId: saved._id
        });
    }
    catch (error) {
        console.error('Cron job error:', error);
        // Close MongoDB connection if it's open
        if (mongoose_1.default.connection.readyState === 1) {
            await mongoose_1.default.connection.close();
        }
        return res.status(500).json({
            success: false,
            error: error instanceof Error ? error.message : 'Unknown error'
        });
    }
}
