# Vercel Deployment Checklist

## ✅ Pre-Deployment Checklist

### 1. Environment Variables
Make sure these are configured in Vercel:
- [ ] `DB_HOST` - Your database host (use cloud database)
- [ ] `DB_USER` - Database username
- [ ] `DB_PASSWORD` - Database password
- [ ] `DB_NAME` - Database name
- [ ] `JWT_SECRET` - Secret key for JWT tokens
- [ ] `JWT_EXPIRES_IN` - JWT expiration time (e.g., "24h")
- [ ] `NODE_ENV` - Set to "production"
- [ ] `UPSTASH_REDIS_REST_URL` - Redis URL (if using)
- [ ] `UPSTASH_REDIS_REST_TOKEN` - Redis token (if using)
- [ ] `MONGODB_URI` - MongoDB connection string for panchang data
- [ ] `CRON_SECRET` - Secret key for cron job authentication
- [ ] `URL_SOCKET` - Redis socket URL (if using)
- [ ] `TOKEN_SOCKET` - Redis socket token (if using)

### 2. Database Setup
- [ ] Use a cloud database (AWS RDS, PlanetScale, Railway, etc.)
- [ ] Ensure database is accessible from Vercel's servers
- [ ] Test database connection locally with production credentials

### 3. File Storage
- [ ] Consider migrating from local file storage to cloud storage
- [ ] Update file upload paths in controllers if needed
- [ ] Test file upload functionality

### 4. Code Changes Made
- [x] Created `vercel.json` configuration
- [x] Created `api/index.ts` entry point
- [x] Updated static file paths in `app.ts`
- [x] Added health check endpoint
- [x] Updated `package.json` scripts
- [x] Added Vercel cron job configuration
- [x] Created `api/cron.ts` for automated panchang fetching
- [x] Created `api/trigger-cron.ts` for manual testing
- [x] Updated environment variables for cron functionality

## 🚀 Deployment Steps

### Option 1: Vercel Dashboard
1. Go to [vercel.com](https://vercel.com)
2. Click "New Project"
3. Import your Git repository
4. Configure environment variables
5. Deploy

### Option 2: Vercel CLI
```bash
# Install Vercel CLI
npm i -g vercel

# Login to Vercel
vercel login

# Deploy
vercel

# Follow the prompts
```

## 🔍 Post-Deployment Testing

1. **Health Check**: Visit `https://your-app.vercel.app/health`
2. **API Endpoints**: Test your main API routes
3. **Database**: Verify database connections work
4. **File Uploads**: Test file upload functionality
5. **Authentication**: Test login/register endpoints
6. **Cron Job**: Test manual trigger at `https://your-app.vercel.app/api/trigger-cron`
7. **MongoDB**: Verify panchang data is being saved correctly

## 🐛 Common Issues & Solutions

### Issue: Database Connection Failed
**Solution**: 
- Use cloud database (not localhost)
- Check environment variables
- Verify database credentials

### Issue: File Uploads Not Working
**Solution**:
- Use cloud storage (AWS S3, Cloudinary)
- Update file paths in controllers
- Check file permissions

### Issue: CORS Errors
**Solution**:
- Update CORS configuration in `app.ts`
- Add specific origins instead of `*`

### Issue: Function Timeout
**Solution**:
- Check `vercel.json` maxDuration setting
- Optimize database queries
- Use connection pooling

### Issue: Cron Job Not Running
**Solution**:
- Verify `CRON_SECRET` environment variable is set
- Check Vercel cron job logs in dashboard
- Ensure MongoDB connection is working
- Test manual trigger endpoint first

## 📞 Support

If you encounter issues:
1. Check Vercel function logs
2. Verify environment variables
3. Test endpoints locally first
4. Check database connectivity
