import { Request, Response } from 'express';
import bcrypt from 'bcryptjs';
import jwt from 'jsonwebtoken';
import { findUserByContact, createUserAccount,updateUserPassword, updateUserPass,getAllUsers} from '../models/userModel';
import { findAstrologerByContact } from '../models/astrologerModel';
import { findbpartnerByContact }  from '../models/bpartnerModel';
import { getOtp, deleteOtp, setOtp } from '../otpStore/otpStore';
import { updateUserDetails } from '../models/servicesModel';
import dotenv from 'dotenv';
import axios from 'axios';
import {  getuser  } from '../services/inmemoery';
dotenv.config();


const JWT_SECRET = process.env.JWT_SECRET;
if (!JWT_SECRET) {
  throw new Error('JWT_SECRET is not defined');
}



async function sendSMS(Phone: string, message: string): Promise<void> {
  
  const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';

  const params = {
    key: '467DD867AC81DD',
    campaign: '0',
    routeid: '13',
    type: 'text',
    contacts: Phone,
    senderid: 'MOJIJA',
    msg: message,
    template_id: '1707174402396213814'
  };

  try {
    const response = await axios.get(url, { params });
    console.log(`SMS sent to ${Phone}:`, response.data);
  } catch (error) {
    console.error(`Failed to send SMS to ${Phone}:`, error);
    throw new Error('Failed to send SMS');
  }
}


async function sendSMS2(Phone: string, message: string): Promise<void> {
  
  const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';

  const params = {
    key: '467DD867AC81DD',
    campaign: '0',
    routeid: '13',
    type: 'text',
    contacts: Phone,
    senderid: 'MOJIJA',
    msg: message,
    template_id: '1707174774488064756'
  };

  try {
    const response = await axios.get(url, { params });
    console.log(`SMS sent to ${Phone}:`, response.data);
  } catch (error) {
    console.error(`Failed to send SMS to ${Phone}:`, error);
    throw new Error('Failed to send SMS');
  }
}






export const Register = async (req: Request, res: Response): Promise<void> => {
  // const { name, Phone, Password, otp } = req.body;
  const { name, Phone, Password, otp, email, address, state, pincode, dob, birthplace } = req.body;


  if (!name || !Phone || !Password || !otp) {
    res.status(400).json({ success: false, message: "Name, Phone, password, and OTP are required." });
    return;
  }
  
  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;

  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: "Invalid or expired OTP" });
    return;
  }

  try {

    const existingUser = await findUserByContact(Phone);
    if (existingUser && existingUser.id) {
      res.status(400).json({ success: false, message: "A User already exists with this Phone number." });
      return;
      
    }

    const existingAstrologer = await findAstrologerByContact(Phone);
    if (existingAstrologer && existingAstrologer.id) {
      res.status(400).json({ success: false, message: "An Astrologer already exists with this Phone number." });
      return;
    }

     const  exsitingbpartner = await findbpartnerByContact(Phone);
     if (exsitingbpartner && exsitingbpartner.id) {
          res.status(400).json({ success: false, message: "A Business Partner already exists with this phone number." });
          return;
    }
    
    const passwordHash = await bcrypt.hash(Password, 10);
    // await createUserAccount(name, Phone, passwordHash);
    await createUserAccount(
  name,
  Phone,
  passwordHash,
  email,
  address,
  state,
  pincode,
  dob,
  birthplace
);

    const newUser = await findUserByContact(Phone);
    if (!newUser) {
      console.log(newUser);
      res.status(500).json({ success: false, message: "Failed to create user" });
      return;
    }

    await deleteOtp(Phone);

    res.json({
      success: true,
      message: "User registered successfully",
     
    });
  } catch (error) {
    console.error("Registration error:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  }
};


export const Login = async (req: Request, res: Response): Promise<void> => {
  const { Phone, Password } = req.body;
  console.log(Phone, Password);
  if (!Phone || !Password) {
    res.status(400).json({ success: false, message: 'Phone and password are required' });
    return;
  }

  try {
    const user = await findUserByContact(Phone);
    console.log(user);

    if (!user) {
      res.status(404).json({ success: false, message: 'User not found' });
      return;
    }

    if (!user.password) {
      res.status(500).json({ success: false, message: 'User password not found' });
      return;
    }
    
    const alreadylogin =await getuser(Phone);
    if (alreadylogin) {
        res.status(400).json({success: false, message:"User is already log in."});
        return;
    }
    
    const isMatch = await bcrypt.compare(Password, user.password);
    if (!isMatch) {
      res.status(401).json({ success: false, message: 'Invalid credentials' });
      return;
    }
    const token = jwt.sign({ id: user.id, name: user.name }, JWT_SECRET as string, { expiresIn: "15d" });
    

    res.cookie('token', token, {
      httpOnly: false,
      secure: false,
      sameSite: 'none',
      maxAge: 15 * 24 * 60 * 60 * 1000 
    });

    console.log(token);
    const { password, ...userWithoutPassword } = user;

    res.status(200).json({ success: true, message: 'Login successful', user: userWithoutPassword });
  } catch (error) {
    console.error('Login error:', error);
    res.status(500).json({ success: false, message: 'Server error' });
  }
};



export const FrogotpassendOTP = async (req: Request, res: Response): Promise<void> => {
  const { Phone } = req.body;
  if (!Phone) {
    res.status(400).json({ success: false, message: 'Phone number is required' });
    return;
  }

  try {
    const user = await findUserByContact(Phone);
    if (!user) {
      res.status(404).json({ success: false, message: 'User with this Phone number does not exist' });
      return;
    }

    const otp = Math.floor(100000 + Math.random() * 900000).toString();

    await setOtp(Phone, otp);
    
    await sendSMS2(Phone, `${otp} is your password reset OTP. Do not share it with anyone Regards MOJIJA.`);

    res.json({ success: true, message: 'OTP sent successfully' });
  } catch (error) {
    console.error('Error sending OTP:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};

export const Sendotp = async (req: Request, res: Response): Promise<void> => {
  const { Phone }= req.body;

  if (!Phone) {
    res.status(400).json({ success: false, message: "Phone number required" });
    return;
  }

  const otp: string = Math.floor(100000 + Math.random() * 900000).toString();

 
  await setOtp(Phone, otp);
  
  await sendSMS(Phone, `${otp} is your Login OTP. Do not share it with anyone Regards MOJIJA.`);
  console.log(otp);

  res.json({ success: true, message: "OTP sent successfully" });
}


export const Forgotpass = async (req: Request, res: Response): Promise<void> => {
  const { Phone, newPassword, otp } = req.body;

  if (!Phone || !newPassword || !otp) {
    res.status(400).json({ success: false, message: 'Phone, new password, and OTP are required' });
    return;
  }

  const otpStr = await getOtp(Phone);
const storedOtpStr = otpStr ? String(otpStr).trim() : null;
const storedOtp = otp ? otp.trim() : null;

  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: 'Invalid or expired OTP' });
    return;
  }

console.log('Provided OTP:', `"${otp}"`, 'Type:', typeof otp);
  try {
    const hashedPassword = await bcrypt.hash(newPassword, 10);
    await updateUserPassword(Phone, hashedPassword);
    await deleteOtp(Phone);

    res.json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error updating password:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};

export const updateUserDetailsController = async (req: Request, res: Response): Promise<void> => {
    const { contact } = req.params;
    const { name, email, gender } = req.body;
    // console.log(contact);

    if (!name || !email || !gender) {
        res.status(400).json({ success: false, message: "Name, email, and gender are required." });
        return;
    }

    try {
        const user = await findUserByContact(contact);
        if (!user) {
            res.status(404).json({ success: false, message: "User not found." });
            return;
        }

        const updatedUser = await updateUserDetails(contact, name, email, gender);

        if (!updatedUser) {
            res.status(500).json({ success: false, message: "Failed to update user details." });
            return;
        }

        res.json({ success: true, message: "User details updated successfully.", user: updatedUser });
    } catch (error) {
        console.error("Update user details error:", error);
        res.status(500).json({ success: false, message: "Internal server error" });
    }
};


export const updateuserpassword = async (req: Request, res: Response): Promise<void> => {
  const {new_password, current_password, User_id } = req.body;
  
  const user_id = Number(User_id); 

  if (!user_id || !current_password || !new_password) {
    res.status(400).json({ success: false, message: 'New password and Old one are required!' });
  }
 
  try {

    await updateUserPass(user_id,current_password,new_password);

    res.json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error updating password:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};



export const getAllUsersController = async (req: Request, res: Response): Promise<void> => {
  try {
    const users = await getAllUsers();

    if (!users || users.length === 0) {
      res.status(404).json({ success: false, message: "No users found" });
      return;
    }

    res.status(200).json({
      success: true,
      message: "Users list fetched successfully",
      users
    });

  } catch (error) {
    console.error("Get All Users Error:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  }
};
