import { Request, Response } from 'express';
import { fetchAllAstrologers, fetchuserdata, fetchwalletbalance, fetchastrologerdata, 
  UpdateAstroProfileImage, fetchastrologerwalletdata, fetchAllPoojas, fetchpoojadetails, 
  fetchmarquee, fetchastrobank, updateAstroBank, fetchusechathistory,fetchAstrologerInteractionHistory } from '../models/servicesModel';
import {findAstrologerByContact} from '../models/astrologerModel'


interface MulterRequest extends Request {
  file?: Express.Multer.File;
}

export const fetchAllAstrologer = async (req: Request, res: Response): Promise<void> => {
     
    try {
        const astrologers = await fetchAllAstrologers();
        res.status(200).json({ success: true, data: astrologers });
      } catch (error) {
        console.error('Error in /astrologers route:', error);
        res.status(500).json({ success: false, error: 'Failed to fetch astrologers' });
      }
};
  
export const fetchuserdeatils = async(req: Request, res: Response) :Promise<void> =>{
  const { Phone } = req.body;
  try{
    const user = await fetchuserdata(Phone);
    res.status(200).json({success: true, data: user})
  }catch(error){
    res.status(500).json({success: false, error:"Failed to fetch user deatils"});
  }
}

export const fetchastrologerdeatils = async(req: Request, res: Response) :Promise<void> =>{
  const { Phone } = req.body;
  try{


    
    const user = await fetchastrologerdata(Phone);
    res.status(200).json({success: true, data: user})
  }catch(error){
    res.status(500).json({success: false, error:"Failed to fetch astrologer deatils"});
  }
}

export const fetchuserwallet = async(req: Request, res: Response) :Promise<void> =>{

  const { User_id } = req.query;
  const userId = Number(User_id);
  try{
    
    if (!User_id) {
      res.status(400).json({success: false, error: "user_id is required"});
      return;
    }
    
    const data = await fetchwalletbalance(userId as number);
    res.status(200).json({success: true,  data})
  }catch(error){
    res.status(500).json({success: false, error:"Failed to fetch user deatils"});
  }
}


export const updateastroprofileimage = async (req: MulterRequest, res: Response): Promise<void> => {
  const  {Phone} = req.body;
  const Profile_image = req.file ? `https://backend.navambhaw.com/uploads/${req.file.filename}`: '';
  
  try{
  const astrologer = await findAstrologerByContact(Phone);
    if (!astrologer) {
      res.status(404).json({ success: false, message: 'Astrologer with this phone number does not exist' });
      return;
    }

   
    await UpdateAstroProfileImage(Profile_image, Phone ); 
    res.status(200).json({success: true, message: "Image Uploaded successfully." });
   }
   catch(error){
    res.status(500).json({ success: false, message: "Internal server error." });
   }
}

export const fetchastrowallet = async(req: Request, res: Response) :Promise<void> =>{
  const { Phone } = req.body;
  try{
    const wallet = await fetchastrologerwalletdata(Phone);
    res.status(200).json({success: true, data: wallet})
  }catch(error){
    res.status(500).json({success: false, error:"Failed to fetch astrologer deatils"});
  }
}


export const fetchallpoojas = async(req: Request, res: Response) :Promise<void> =>{
  
  try{
      
    const poojas = await fetchAllPoojas();
    res.status(200).json({success: true, data: poojas})
    
  }catch(error){
    res.status(500).json({success: false, error:"Failed to fetch Pooja deatils"});
  }
}

// fetch one pooja data

export const fetchpoojadata = async(req: Request, res: Response) :Promise<void> =>{

  const { pooja_id } = req.query;
  const Poojaid = Number(pooja_id);

  try{
    
    if (!Poojaid) {
      res.status(400).json({success: false, error: "pooja_id is required"});
      return;
    }
    
    const data = await fetchpoojadetails(Poojaid as number);
    
    res.status(200).json({success: true,  data})
    
  }catch(error){
    
    res.status(500).json({success: false, error:"Failed to fetch user deatils"});
  }
}


export const getmarquee = async(req: Request, res: Response) :Promise<void> =>{

  try{
    
    const data = await fetchmarquee();
    
    res.status(200).json({success: true,  data})
    
  }catch(error){
    
    res.status(500).json({success: false, error:"Failed to fetch marquee deatils"});
  }
}

export const getastrobank = async(req: Request, res: Response) :Promise<void> =>{
    const { astrologer_id } = req.query;
  const astro_id = Number(astrologer_id);
  try{
    
    const data = await fetchastrobank(astro_id);
    
    res.status(200).json({success: true,  data})
    
  }catch(error){
    
    res.status(500).json({success: false, error:"Failed to fetch bank deatils"});
  }
}



export const updateAstrologerBank = async (req: Request, res: Response) :Promise<void>=> {
  const { astro_id, account_holder, bank_name, account_number, ifsc_code } = req.body;

  if (!astro_id || !account_holder || !bank_name || !account_number || !ifsc_code) {
     res.status(400).json({ success: false, message: 'All fields are required.' });
  }

  try {
    await updateAstroBank(astro_id, account_holder, bank_name, account_number, ifsc_code);
     res.status(200).json({ success: true, message: 'Bank details updated successfully.' });
  } catch (error) {
     res.status(500).json({ success: false, message: 'Failed to update bank details.' });
  }
};


export const userchathistory = async(req: Request, res: Response) :Promise<void> =>{
    const { Phone } = req.query;

  try{
    
    const data = await fetchusechathistory(Phone as string);
    
    res.status(200).json({success: true,  data})
    
  }catch(error){
    
    res.status(500).json({success: false, error:"Failed to Chat History"});
  }
}


// export const getAstrologerInteractionHistory = async (
//   req: Request,
//   res: Response
// ): Promise<void> => {

//   const astrologerId = Number(req.query.astrologer_id);
//   const from = req.query.from as string | undefined;
//   const to = req.query.to as string | undefined;

//   // ✅ Validate astrologer_id
//   if (!astrologerId || isNaN(astrologerId)) {
//     res.status(400).json({
//       success: false,
//       message: 'Valid astrologer_id is required'
//     });
//     return;
//   }

//   try {
//     const data = await fetchAstrologerInteractionHistory(
//       astrologerId,
//       from,
//       to
//     );

//     res.status(200).json({
//       success: true,
//       count: data.length,
//       data
//     });

//   } catch (error) {
//     console.error(
//       'Error fetching astrologer interaction history:',
//       error
//     );

//     res.status(500).json({
//       success: false,
//       message: 'Failed to fetch astrologer interaction history'
//     });
//   }
// };

export const getAstrologerInteractionHistory = async (
  req: Request,
  res: Response
): Promise<void> => {
  try {
    const query = req.query as Record<string, string | undefined>;
    const astrologerId = Number(query.astrologer_id);
    const from = query.from;
    const to = query.to;
    const page = query.page ? parseInt(query.page, 10) : 1;
    const limit = 10;
    const offset = (page - 1) * limit;

    if (!astrologerId || isNaN(astrologerId)) {
      res.status(400).json({
        success: false,
        message: 'Valid astrologer_id is required',
      });
      return; // don't return res
    }

    const data = await fetchAstrologerInteractionHistory(astrologerId, from, to, limit, offset);

    // Ensure data is an array
    const dataArray = Array.isArray(data) ? data : [];

    res.status(200).json({
      success: true,
      page,
      limit,
      count: dataArray.length,
      data: dataArray,
    });

  } catch (error) {
    console.error('Error fetching astrologer interaction history:', error);
    res.status(500).json({
      success: false,
      message: 'Failed to fetch astrologer interaction history',
    });
  }
};





import { fetchAdminAstrologerWallets } from '../models/servicesModel';

export const getAdminAstrologerWallets = async (
  req: Request,
  res: Response
): Promise<void> => {
  try {
    const data = await fetchAdminAstrologerWallets();

    res.status(200).json({
      success: true,
      count: data.length,
      data,
    });
  } catch (error) {
    console.error('Error fetching admin astrologer wallets:', error);
    res.status(500).json({
      success: false,
      message: 'Failed to fetch astrologer wallet list',
    });
  }
};
