import axios from "axios";
import dotenv from 'dotenv';
import { Request, Response } from 'express';
import mongoose from 'mongoose';
dotenv.config();

const now = new Date();
const timezone1 = -now.getTimezoneOffset() / 60;

const userId = process.env.userId;
const apiKey = process.env.apiKey;
const language = process.env.language;
const auth = 'Basic ' + Buffer.from(`${userId}:${apiKey}`).toString('base64');



const mongoURI = "mongodb+srv://ankitdonhai:MGQEJ1DUF7V1VSds@cluster0.ad27ekx.mongodb.net/?retryWrites=true&w=majority&appName=Cluster0"; 

mongoose.connect(mongoURI, {
  serverSelectionTimeoutMS: 15000, 
})
.then(() => console.log("✅ MongoDB Connected"))
.catch((err) => {
  console.error("❌ MongoDB connection error:", err.message);
});
const PanchangSchema = new mongoose.Schema({
  date: { type: Date, default: Date.now },
  day: String,
  tithi: String,
  nakshatra: String,
  yog: String,
  karan: String,
  sunrise: String,
  sunset: String,
  vedic_sunrise: String,
  vedic_sunset: String,
});

export const astrodeatils = async (req: Request, res: Response): Promise<void> => {

const data =req.body;


axios.post(`https://json.astrologyapi.com/v1/birth_details`, data, {
  headers: {
    'Authorization': auth,
    'Content-Type': 'application/json',
    'Accept-Language': language,
  },
})
.then((response) => {
  console.log(response.data);
  res.status(200).json({ success: true, message: response.data });
})
.catch((error) => {
  console.error(error.response ? error.response.data : error.message);
  res.status(400).json({ success: false, message: error });
});
};


export const birthdetails = async (req: Request, res: Response): Promise<void> => {

    const data =req.body;
    
    axios.post(`https://json.astrologyapi.com/v1/astro_details`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });

};
    


export const planets = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/planets`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const ghatchakra = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/get_chakra`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};


export const geodetails = async (req: Request, res: Response): Promise<void> => {
    const {place} =req.body;
    const maxRows =6;
    
    axios.post(`https://json.astrologyapi.com/v1/geo_details`, {place,maxRows}, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};


export const timezone = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/timezone`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

// nothing will happens with params it called for D9 everytime
export const horochartd9 = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/horo_chart/D9`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const horochartd1 = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/horo_chart/D1`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

// not subscribedd
export const timzonewithdst = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;
    const place=data.place;
    const date=`${data.day}-${data.month}-${data.year}`;
    const maxRows=2;
   

   axios.post(`https://json.astrologyapi.com/v1/geo_details`, {place,maxRows}, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
            // const latitude=response.data.geonames[0].latitude;
            // const longitude=response.data.geonames[0].longitude;

             const latitude=  19.23232;
             const longitude= 72.23234;
             
            console.log(latitude,longitude,date);
            axios.post(`https://json.astrologyapi.com/v1/timzone_with_dst`, 
              {date, latitude, longitude},
            {
            headers: {
              'Authorization': auth,
              'Content-Type': 'application/json',
              'Accept-Language': language,
            },
            })
              .then((response) => {
                console.log(response.data);
                res.status(200).json({ success: true, message: response.data });
              })
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    

    
   
    
};


export const currentvdasha = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;
    
    axios.post(`https://json.astrologyapi.com/v1/current_vdasha`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};



export const genralascendantreport = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/general_ascendant_report`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const alltimepancahng = async (req: Request, res: Response): Promise<void> => {
  
    const currentDetails = req.body;
console.log(currentDetails);
    
    axios.post(`https://json.astrologyapi.com/v1/basic_panchang`, currentDetails, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.log(error);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const basicpanchang = async (req: Request, res: Response): Promise<void> => {
  try {
      
    const Panchang = mongoose.model('Panchang', PanchangSchema);
    const latestPanchang = await Panchang.findOne().sort({ date: -1 });

    if (!latestPanchang) {
      res.status(404).json({ success: false, message: "No Panchang data found" });
      return;
    }
    res.status(200).json({ success: true, message: latestPanchang });
  } catch (error) {
    console.error("DB fetch error:", error);
    res.status(500).json({ success: false, message: "Failed to fetch Panchang data" });
  }
};


// nothing will happens with params it called for D9 everytime
export const horochartimaged1 = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/horo_chart_image/D1`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const horochartimaged9 = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/horo_chart_image/D9`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const kalsarpadetails = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;

    
    axios.post(`https://json.astrologyapi.com/v1/kalsarpa_details`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
};

export const numerotable = async (req: Request, res: Response): Promise<void> => {
    const data =req.body;
    
    axios.post(`https://json.astrologyapi.com/v1/numero_table`, data, {
      headers: {
        'Authorization': auth,
        'Content-Type': 'application/json',
        'Accept-Language': language,
      },
    })
    .then((response) => {
      console.log(response.data);
      res.status(200).json({ success: true, message: response.data });
    })
    .catch((error) => {
      console.error(error.response ? error.response.data : error.message);
      res.status(400).json({ success: false, message: error });
    });
    
}
