import { Request, Response } from 'express';
import bcrypt from 'bcryptjs';
import jwt from 'jsonwebtoken';
import { findbpartnerByContact, createbpartnerAccount,updatebpartnerPassword} from '../models/bpartnerModel';
import { findAstrologerByContact } from '../models/astrologerModel';
import {findUserByContact} from '../models/userModel'
import { getOtp, deleteOtp, setOtp } from '../otpStore/otpStore';
import dotenv from 'dotenv';
import axios from 'axios';
dotenv.config();


const JWT_SECRET = process.env.JWT_SECRET;
if (!JWT_SECRET) {
  throw new Error('JWT_SECRET is not defined');
}



async function sendSMS(Phone: string, message: string): Promise<void> {
  
  const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';

  const params = {
    key: '467DD867AC81DD',
    campaign: '0',
    routeid: '13',
    type: 'text',
    contacts: Phone,
    senderid: 'MOJIJA',
    msg: message,
    template_id: '1707174402396213814'
  };

  try {
    const response = await axios.get(url, { params });
    console.log(`SMS sent to ${Phone}:`, response.data);
  } catch (error) {
    console.error(`Failed to send SMS to ${Phone}:`, error);
    throw new Error('Failed to send SMS');
  }
}


async function sendSMS2(Phone: string, message: string): Promise<void> {
  
  const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';

  const params = {
    key: '467DD867AC81DD',
    campaign: '0',
    routeid: '13',
    type: 'text',
    contacts: Phone,
    senderid: 'MOJIJA',
    msg: message,
    template_id: '1707174774488064756'
  };

  try {
    const response = await axios.get(url, { params });
    console.log(`SMS sent to ${Phone}:`, response.data);
  } catch (error) {
    console.error(`Failed to send SMS to ${Phone}:`, error);
    throw new Error('Failed to send SMS');
  }
}



export const Sendotp = async (req: Request, res: Response): Promise<void> => {
  const { Phone }: { Phone: string } = req.body;

  if (!Phone) {
    res.status(400).json({ success: false, message: "Phone number required" });
    return;
  }

  const otp: string = Math.floor(100000 + Math.random() * 900000).toString();

 
  await setOtp(Phone, otp);
  
  await sendSMS(Phone, `${otp} is your Login OTP. Do not share it with anyone Regards MOJIJA.`);
  console.log(otp);

  res.json({ success: true, message: "OTP sent successfully" });
}


function generateCouponCode(length: number = 6): string {
  const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  let coupon = '';

  for (let i = 0; i < length; i++) {
    const randomIndex = Math.floor(Math.random() * characters.length);
    coupon += characters[randomIndex];
  }

  return coupon;
}


export const Register = async (req: Request, res: Response): Promise<void> => {
  const { name, Phone, Password, otp, email} = req.body;


  if (!name || !Phone || !Password || !otp || !email) {
    res.status(400).json({ success: false, message: "Name, Phone, password, and OTP are required." });
    return;
  }

  
  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;

  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: "Invalid or expired OTP" });
    return;
  }

  try {
    
    const existingbpartner = await findbpartnerByContact(Phone);
    if (existingbpartner && existingbpartner.id) {
      res.status(400).json({ success: false, message: "A Number is already exists in our record." });
      return;
    }

    const existinguser = await findUserByContact(Phone);
    if (existinguser && existinguser.id) {
      res.status(400).json({ success: false, message: "A User is already exists in our record." });
      return;
    }

    const existingAstrologer = await findAstrologerByContact(Phone);
    if (existingAstrologer && existingAstrologer.id) {
      res.status(400).json({ success: false, message: "An Astrologer already exists with this Phone number." });
      return;
    }
    const coupon_code =  generateCouponCode();
    const passwordHash = await bcrypt.hash(Password, 10);
    await createbpartnerAccount(name, Phone, passwordHash, coupon_code,email);

    const newUser = await findbpartnerByContact(Phone);
    if (!newUser) {
      console.log(newUser);
      res.status(500).json({ success: false, message: "Failed to create user" });
      return;
    }

    await deleteOtp(Phone);

    

    res.json({
      success: true,
      message: "User registered successfully",
     
    });
  } catch (error) {
    console.error("Registration error:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  }
};








export const Login = async (req: Request, res: Response): Promise<void> => {
  const { Phone, Password } = req.body;
  // console.log(Phone, password);
  if (!Phone || !Password) {
    res.status(400).json({ success: false, message: 'Phone and password are required' });
    return;
  }

  try {
    const user = await findbpartnerByContact(Phone);
    console.log(user);

    if (!user) {
      res.status(404).json({ success: false, message: 'User not found' });
      return;
    }

    if (!user.password) {
      res.status(500).json({ success: false, message: 'User password not found' });
      return;
    }
    
    
    const isMatch = await bcrypt.compare(Password, user.password);
    if (!isMatch) {
      res.status(401).json({ success: false, message: 'Invalid credentials' });
      return;
    }
    const token = jwt.sign({ id: user.id, name: user.name }, JWT_SECRET as string, { expiresIn: "15d" });
    

    res.cookie('token', token, {
      httpOnly: false,
      secure: false, 
      sameSite: 'none',
      maxAge: 15 * 24 * 60 * 60 * 1000 
    });

    const { password, ...bpartnerWithoutPassword } = user;
    res.status(200).json({ success: true, message: 'Login successful', user: bpartnerWithoutPassword });
  } catch (error) {
    console.error('Login error:', error);
    res.status(500).json({ success: false, message: 'Server error' });
  }
};



export const FrogotpassendOTP = async (req: Request, res: Response): Promise<void> => {
  const { Phone } = req.body;
  if (!Phone) {
    res.status(400).json({ success: false, message: 'Phone number is required' });
    return;
  }

  try {
    const user = await findbpartnerByContact(Phone);
    if (!user) {
      res.status(404).json({ success: false, message: 'User with this Phone number does not exist' });
      return;
    }

    const otp = Math.floor(100000 + Math.random() * 900000).toString();

    await setOtp(Phone, otp);
    
    await sendSMS2(Phone, `${otp} is your password reset OTP. Do not share it with anyone Regards MOJIJA.`);

    res.json({ success: true, message: 'OTP sent successfully' });
  } catch (error) {
    console.error('Error sending OTP:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};





export const Forgotpass = async (req: Request, res: Response): Promise<void> => {
  const { Phone, newPassword, otp } = req.body;

  if (!Phone || !newPassword || !otp) {
    res.status(400).json({ success: false, message: 'Phone, new password, and OTP are required' });
    return;
  }

  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;

  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: 'Invalid or expired OTP' });
    return;
  }
 
  try {
    const hashedPassword = await bcrypt.hash(newPassword, 10);
    await updatebpartnerPassword(Phone, hashedPassword);

    await deleteOtp(Phone);

    res.json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error updating password:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};




