import { Request , Response } from 'express';
import bcrypt from 'bcryptjs';
import jwt from 'jsonwebtoken';
import { findAstrologerByContact, createAstrologerAccount, updateAstrologerPassword, updateAstrorPass, verifyAstrologer, unverifyAstrologer, updateAstrologerPriceAndCommission, getAstrologerPriceAndCommission,fetchAllAstrologers
  , toggleAstrologerFreeStatusByMobile,
  fetchAllAstrologersWithPriceCommission
} from '../models/astrologerModel';
import { findUserByContact} from '../models/userModel';
import {findbpartnerByContact}  from '../models/bpartnerModel';
import { getOtp, deleteOtp, setOtp } from '../otpStore/otpStore';
import dotenv from 'dotenv';
import axios from 'axios';
import {  getastro  } from '../services/inmemoery';

dotenv.config();


const JWT_SECRET = process.env.JWT_SECRET;
if (!JWT_SECRET) {
  throw new Error('JWT_SECRET is not defined');
}


interface MulterRequest extends Request {
  file?: Express.Multer.File;
}

async function sendSMS(Phone: string, message: string): Promise<void> {
  
    const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';
  
    const params = {
      key: '467DD867AC81DD',
      campaign: '0',
      routeid: '13',
      type: 'text',
      contacts: Phone,
      senderid: 'MOJIJA',
      msg: message,
      template_id: '1707174402396213814'
    };
  
    try {
      const response = await axios.get(url, { params });
      console.log(`SMS sent to ${Phone}:`, response.data);
    } catch (error) {
      console.error(`Failed to send SMS to ${Phone}:`, error);
      throw new Error('Failed to send SMS');
    }  
  
  }
  
  
  async function sendSMS2(Phone: string, message: string): Promise<void> {
  
    const url = 'https://bulksms.smsroot.com/app/smsapi/index.php';
  
    const params = {
      key: '467DD867AC81DD',
      campaign: '0',
      routeid: '13',
      type: 'text',
      contacts: Phone,
      senderid: 'MOJIJA',
      msg: message,
      template_id: '1707174774488064756'
    };
    try {
      const response = await axios.get(url, { params });
      console.log(`SMS sent to ${Phone}:`, response.data);
    } catch (error) {
      console.error(`Failed to send SMS to ${Phone}:`, error);
      throw new Error('Failed to send SMS');
    }
  }



export const Sendotp = async (req: Request, res: Response): Promise<void> => {


  const Phone: string = req.body.Phone || req.body.phone;


  if (!Phone) {
    res.status(400).json({ success: false, message: "Phone number required" });
    return;
  }

  const otp: string = Math.floor(100000 + Math.random() * 900000).toString();

  await setOtp(Phone, otp);
  await sendSMS(Phone, `${otp} is your Login OTP. Do not share it with anyone Regards MOJIJA.`);
  console.log(otp);
  // console.log(`OTP for ${phone}: ${otp}`);

  res.json({ success: true, message: "OTP sent successfully" });
}



export const Register = async (req: MulterRequest, res: Response): Promise<void> => {
  const {
    Astrologer_name,
    Phone,
    Email,
    Address,  
    Pincode,
    State,
    Specialization,
    Languages,
    Experience,
    Highest_qualification,
    Description,
    Password,
    otp
  } = req.body;

  
  if (
    !Astrologer_name || !Phone || !Email || !Address || !Pincode || !State ||
    !Specialization || !Languages || !Experience || !Highest_qualification ||
    !Description  || !Password || !otp
  ) {
    res.status(400).json({ success: false, message: "All fields are required." });
    return;
  }

  
  // const storedOtp = await getOtp(Phone);

  
  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;
  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: "Invalid or expired OTP." });
    return;
  }

  try {
    // Check for existing astrologer
    const existingAstrologer = await findAstrologerByContact(Phone);

    if (existingAstrologer &&  existingAstrologer.id) {
      res.status(400).json({ success: false, message: "An astrologer already exists with this phone number." });
      return;
    }

    const existingUser = await findUserByContact(Phone);

    if (existingUser && existingUser.id) {
      res.status(400).json({ success: false, message: "A User already exists with this phone number." });
      return;
    }
    
    const  exsitingbpartner = await findbpartnerByContact(Phone);

    if (exsitingbpartner && exsitingbpartner.id) {
      res.status(400).json({ success: false, message: "A Business Partner already exists with this phone number." });
      return;
    }

    const passwordHash = await bcrypt.hash(Password, 10);

    const Profile_image = req.file
          ? `https://backend.navambhaw.com/uploads/${req.file.filename}`: '';

    await createAstrologerAccount(
      
      Astrologer_name,
      Phone,
      Email,
      Address,
      Pincode,
      State,
      Specialization,
      Languages,
      Experience,
      Highest_qualification,
      Description,
      Profile_image,
      passwordHash
    );

   
    const newAstrologer = await findAstrologerByContact(Phone);
    if (!newAstrologer) {
      res.status(500).json({ success: false, message: "Failed to create astrologer." });
      return;
    }

    await deleteOtp(Phone);
    

   
    res.json({
      success: true,
      message: "Astrologer registered successfully.",
      
    });
  } catch (error) {
    console.error("Registration error:", error);
    res.status(500).json({ success: false, message: "Internal server error." });
  }
};



export const Login = async (req: Request, res: Response): Promise<void> => {
  const { Phone, Password, otp } = req.body;

  if (!Phone || !Password || !otp) {
    res.status(400).json({ success: false, message: 'Phone, password and otp are required' });
    return;
  }

  try {
    const astrologer = await findAstrologerByContact(Phone);

    if (!astrologer) {
      res.status(404).json({ success: false, message: 'Astrologer not found' });
      return;
    }

    if (!astrologer.password) {
      res.status(500).json({ success: false, message: 'Astrologer password not found' });
      return;
    }
    const alreadylogin =await getastro(Phone);
    if (alreadylogin) {
        res.status(400).json({success: false, message:"Astorloger is already log in."});
        return;
    }

    
  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;

    if (!storedOtp || storedOtp!== storedOtpStr ) {
      res.status(400).json({ success: false, message: "Invalid or expired OTP." });
      return;
    }


    const isMatch = await bcrypt.compare(Password, astrologer.password);
    if (!isMatch) {
      res.status(401).json({ success: false, message: 'Invalid credentials' });
      return;
    }
    console.log("token has been send.");
    const token = jwt.sign({ id: astrologer.id, name: astrologer.Astrologer_name }, JWT_SECRET, { expiresIn: "7d" });
    await deleteOtp(Phone);
    res.cookie('token', token, {
      httpOnly: false,
      secure: process.env.NODE_ENV === 'production', // use true in production with HTTPS
      sameSite: 'none',
      maxAge: 7 * 24 * 60 * 60 * 1000 
    });

    const { password, ...astroWithoutPassword } = astrologer;

    res.status(200).json({ success: true, message: 'Login successful', astrologer: astroWithoutPassword });
  } catch (error) {
    console.error('Login error:', error);
    res.status(500).json({ success: false, message: 'Server error' });
  }
};




export const FrogotpassendOTP = async (req: Request, res: Response): Promise<void> => {
  const { Phone } = req.body;
  if (!Phone) {
    res.status(400).json({ success: false, message: 'Phone number is required' });
    return;
  }

  try {
    
    const astrologer = await findAstrologerByContact(Phone);
    if (!astrologer) {
      res.status(404).json({ success: false, message: 'Astrologer with this phone number does not exist' });
      return;
    }

    const otp = Math.floor(100000 + Math.random() * 900000).toString();
    await setOtp(Phone, otp);
    await sendSMS2(Phone, `${otp} is your password reset OTP. Do not share it with anyone Regards MOJIJA.`);

    res.json({ success: true, message: 'OTP sent successfully' });
  } catch (error) {
    console.error('Error sending OTP:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};





export const Forgotpass = async (req: Request, res: Response): Promise<void> => {
  const { newPassword, otp, Phone } = req.body;
  // const Phone: string = req.body.Phone
  console.log(newPassword, otp, Phone);

  if (!Phone || !newPassword) {
    res.status(400).json({ success: false, message: 'New password and OTP are required!' });
    return;
  }

  
 
  const otpStr = await getOtp(Phone);
  const storedOtpStr = otpStr ? String(otpStr).trim() : null;
  const storedOtp = otp ? otp.trim() : null;

  if (!storedOtp || storedOtp!== storedOtpStr ) {
    res.status(400).json({ success: false, message: 'Invalid or expired OTP' });
    return;
  }

  try {
    const hashedPassword = await bcrypt.hash(newPassword, 10);
    await updateAstrologerPassword(Phone, hashedPassword);
    await deleteOtp(Phone);
    console.log("Password updated successfully for astrologer with phone:", Phone);
    res.json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error updating password:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};


export const updateastropass = async (req: Request, res: Response): Promise<void> => {
  const {new_password, current_password, user_id } = req.body;
  
  const astro_id = Number(user_id); 

  if (!astro_id || !current_password || !new_password) {
    res.status(400).json({ success: false, message: 'New password and Old one are required!' });
  }
 
  try {

    await updateAstrorPass(astro_id,current_password,new_password);

    res.json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error updating password:', error);
    res.status(500).json({ success: false, message: 'Internal server error' });
  }
};



// ✅ Verify astrologer controller
export const verifyAstrologerController = async (req: Request, res: Response): Promise<void> => {
  try {
    const { id } = req.params;
    await verifyAstrologer(Number(id));
    res.status(200).json({ message: "Astrologer verified successfully" });
  } catch (error) {
    console.error("Verify Error:", error);
    res.status(500).json({ error: "Failed to verify astrologer" });
  }
};

// ✅ Unverify astrologer controller
export const unverifyAstrologerController = async (req: Request, res: Response): Promise<void> => {
  try {
    const { id } = req.params;
    await unverifyAstrologer(Number(id));
    res.status(200).json({ message: "Astrologer unverified successfully" });
  } catch (error) {
    console.error("Unverify Error:", error);
    res.status(500).json({ error: "Failed to unverify astrologer" });
  }
};





// 🔹 Update astrologer price & commission
export const setAstrologerPriceCommission = async (
  req: Request,
  res: Response
): Promise<void> => {
  try {
    const { astro_id, price, commission_percentage } = req.body;

    if (!astro_id || price == null || commission_percentage == null) {
      res.status(400).json({ success: false, message: "Missing fields" });
      return;
    }

    await updateAstrologerPriceAndCommission(
      Number(astro_id),
      Number(price),
      Number(commission_percentage)
    );

    res.json({
      success: true,
      message: "Astrologer price & commission updated successfully",
    });
  } catch (error) {
    console.error("Error in setAstrologerPriceCommission:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  }
};

// 🔹 Fetch astrologer price & commission
export const fetchAstrologerPriceCommission = async (
  req: Request,
  res: Response
): Promise<void> => {
  try {
    const { astro_id } = req.params;

    if (!astro_id) {
      res.status(400).json({ success: false, message: "Astrologer ID required" });
      return;
    }

    const result = await getAstrologerPriceAndCommission(Number(astro_id));

    if (!result) {
      res.status(404).json({ success: false, message: "Astrologer not found" });
      return;
    }

    res.json({ success: true, data: result });
  } catch (error) {
    console.error("Error in fetchAstrologerPriceCommission:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  }
};


// 🔹 Get all astrologers
export const getAllAstrologers = async (req: Request, res: Response): Promise<void> => {
  try {
    const astrologers = await fetchAllAstrologers();
    res.status(200).json({
      success: true,
      data: astrologers,
    });
  } catch (error: any) {
    console.error("Error in getAllAstrologers:", error);
    res.status(500).json({
      success: false,
      message: "Failed to fetch astrologers",
      error: error.message,
    });
  }
};

export const toggleFreeStatusByMobile = async (req: Request, res: Response): Promise<void> => {
  try {
    const { mobileNumber } = req.body;

    if (!mobileNumber || mobileNumber.toString().length < 10) {
      res.status(400).json({ success: false, message: "Valid mobile number required" });
      return;
    }

    const updatedAstro = await toggleAstrologerFreeStatusByMobile(mobileNumber.toString());

    if (!updatedAstro) {
      res.status(404).json({ success: false, message: "Astrologer not found" });
      return;
    }

    res.json({
      success: true,
      message: updatedAstro.is_free === 1 ? "Astrologer is now FREE" : "Astrologer is now PAID",
      data: {
        id: updatedAstro.id,
        mobileNumber: updatedAstro.mobileNumber,
        username: updatedAstro.username || "Astrologer",
        is_free: updatedAstro.is_free,
        price: updatedAstro.price,
        original_price: updatedAstro.original_price || null,
      },
    });
  } catch (error: any) {
    console.error("Toggle free error:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Server error",
    });
  }
};

export const getAllAstrologersWithPriceCommission = async (req: Request, res: Response): Promise<void> => {
  try {
    const astrologers = await fetchAllAstrologersWithPriceCommission();

    res.status(200).json({
      success: true,
      data: astrologers,
    });
  } catch (error: any) {
    console.error("Error in getAllAstrologersWithPriceCommission:", error);
    res.status(500).json({
      success: false,
      message: "Failed to fetch astrologers",
      error: error.message,
    });
  }
};